#ifndef BLAST_GRAPHIC_XYZAXISDX9_H
#define BLAST_GRAPHIC_XYZAXISDX9_H

#include "Blast/Base/RenderableGameComponent.h"
#include "Blast/Graphic/ICamera.h"
#include "Blast/Graphic/DirectX9/Line3DDX9.h"


namespace Blast
{
	namespace Graphic
	{
		/// XYZ\@\SNX
		class XYZAxisDX9 : public Blast::Base::RenderableGameComponent
		{
			public:
				//====================================================================================================
				// Enumerate
				//----------------------------------------------------------------------------------------------------

				/// ̎
				enum ELine
				{
					/// X
					eLINE_X,

					/// Y
					eLINE_Y,

					/// Z
					eLINE_Z,


					/// 񋓗vf̐
					eLINE_COUNT,
				};


				//====================================================================================================
				// Operation
				//----------------------------------------------------------------------------------------------------

				/// RXgN^
				XYZAxisDX9();

				/// fXgN^
				~XYZAxisDX9();


				/// `
				virtual void Render();


				/// Jݒ
				void SetCamera(SP<ICamera>);


				//====================================================================================================
				// Property
				//----------------------------------------------------------------------------------------------------

				/// 擾
				float& GetLengthRef()
				{
					return mLength;
				}

				/// 擾
				const float& GetLengthRef() const
				{
					return mLength;
				}

				/// ݒ
				void SetLength(float length)
				{
					mLength = length;
				}

			private:
				/// C
				SP<Line3DDX9> mPLine;

				/// 
				float mLength;


				/// J
				SP<ICamera> mPCamera;
		};
	};

} // namespace Blast

#endif // BLAST_GRAPHIC_XYZAXISDX9_H