#ifndef BLAST_GRAPHIC_VERTEXBUFFERDX9_H
#define BLAST_GRAPHIC_VERTEXBUFFERDX9_H


namespace Blast
{
	namespace Graphic
	{
		/// DirectX9p̒_obt@ێNX
		class VertexBufferDX9
		{
		public:
			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// _ɑ΂ĉe^{[̍ő{
			static const int mStKMaxInfluenceBoneCount = 4;


			//====================================================================================================
			// Union ^ Struct
			//----------------------------------------------------------------------------------------------------

			/// ʒu
			union SPosition
			{
				struct
				{
					/// XW
					float mX;

					/// YW
					float mY;

					/// ZW
					float mZ;
				};

				/// z
				float m[3];
			};

			/// F
			struct SColor
			{
				/// F
				u32 mColor;
			};

			/// @
			union SNormal
			{
				struct
				{
					/// XW
					float mX;

					/// YW
					float mY;

					/// ZW
					float mZ;
				};

				/// z
				float m[3];
			};

			/// UV
			union SUV
			{
				struct 
				{
					/// U
					float mU;

					/// V
					float mV;
				};

				/// z
				float m[3];
			};

			/// {[CfbNX
			struct SBoneIndex
			{
				/// CfbNXz
				BYTE mIndices[mStKMaxInfluenceBoneCount];
			};

			/// {[EFCg
			struct SBoneWeight
			{
				/// EFCgz
				float mWeights[mStKMaxInfluenceBoneCount];
			};


			// ADD:ɂ낢


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			VertexBufferDX9();

			/// fXgN^
			virtual ~VertexBufferDX9();


			/// obt@擾
			virtual IDirect3DVertexBuffer9* GetBuffer();

			/// _f[^zݒ
			virtual void SetVertices(void* pVertices, u32 count, unsigned size);

			/// TCY擾
			virtual unsigned GetSize() const;
			
			/// 擾
			virtual u32 GetVertexCount() const;

			/// XgCh擾
			virtual int GetStride() const;

		private:
			/// obt@
			CSP<IDirect3DVertexBuffer9> mPBuffer;

			/// TCY
			unsigned mSize;

			/// _
			u32 mCount;

			/// XgCh
			int mStride;			
		};

	} // namespace Graphic
} // namespace Blast

#endif // BLAST_GRAPHIC_VERTEXBUFFERDX9_H