#ifndef BLAST_GRAPHIC_SPRITE3DDX9_H
#define BLAST_GRAPHIC_SPRITE3DDX9_H

#include "Blast/Base/RenderableGameComponent.h"
#include "Blast/Graphic/ISprite.h"

#include "Blast/Graphic/ICamera.h"
#include "Blast/Graphic/ITexture2D.h"

/// MEMO:C^[tF[X̕ǂł傤B
/// ܂͓Ƃ挈B
#include "Blast/Graphic/DirectX9/MeshSpriteDX9.h"
#include "Blast/Graphic/DirectX9/ShaderEffectDX9.h"
#include "Blast/Math/Rectangle.h"


namespace Blast
{
	namespace Graphic
	{
		/// J̃C^[tF[X
		class ICamera;


		/// 3Dp̃XvCg`揈SNX
		class SpriteDX9 : public Blast::Base::RenderableGameComponent
			//public Blast::Graphic::ISprite
		{
		public:
			//====================================================================================================
			// Enumerate
			//----------------------------------------------------------------------------------------------------

			/// _̈ʒu̎
			enum EOrigin
			{
				eORIGIN_UP_LEFT,	///< 
				eORIGIN_UP_CENTER,	///< 
				eORIGIN_UP_RIGHT,	///< E
				eORIGIN_LEFT,		///< 
				eORIGIN_CENTER,		///< 
				eORIGIN_RIGHT,		///< E
				eORIGIN_DOWN_LEFT,	///< 
				eORIGIN_DOWN,		///< 
				eORIGIN_DOWN_RIGHT,	///< E

				eORIGIN_COUNT,		///< 񋓗vf̐
			};


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			SpriteDX9();

			/// fXgN^
			virtual ~SpriteDX9();


			/// 
			void Initialize();

			/// XV
			virtual void Update(float);

			/// `
			virtual void Render();


			/// TCYeNX`TCYɑ
			void FitTextureSize();

			/// öeNX`TCYɑ
			void FitTextureSourceRectangle();



			/// Jݒ
			virtual void SetCamera(SP<ICamera>);


			/* eNX` */

			/// eNX`擾
			virtual SP<ITexture2D> GetTexture();

			/// eNX`擾
			virtual const SP<ITexture2D> GetTexture() const;

			/// eNX`ݒ
			virtual void SetTexture(SP<ITexture2D>);


			/* TCY */

			/// TCY擾
			virtual Blast::Math::Vector2& GetSize();

			/// TCY擾
			virtual const Blast::Math::Vector2& GetSize() const;

			/// TCYݒ
			virtual void SetSize(float width, float height);

			/// TCYݒ
			virtual void SetSize(const Blast::Math::Vector2&);


			/* ö */

			/// öݒ
			virtual void SetSourceRectangle(float topX, float topY, float bottomX, float bottomY);

			/// öݒ
			virtual void SetSourceRectangle(const Blast::Math::Vector2& kRLeftTop, const Blast::Math::Vector2& kRRightBottom);


			/* ʒu */

			/// ʒu擾
			virtual const Blast::Math::Vector3& GetPosition() const;

			/// ʒu擾
			virtual Blast::Math::Vector3& GetPosition();

			/// ʒuݒ
			virtual void SetPosition(float x, float y, float z);

			/// ʒuݒ
			virtual void SetPosition(const Blast::Math::Vector3&);

			/// ړ
			virtual void Move(float x, float y, float z);

			/// ړ
			virtual void Move(const Blast::Math::Vector3&);


			/* gk */

			/// gk擾
			virtual const Blast::Math::Vector2& GetScale() const;

			/// gk擾
			virtual Blast::Math::Vector2& GetScale();

			/// gkݒ
			virtual void SetScale(float x, float y);

			/// gkݒ
			virtual void SetScale(const Blast::Math::Vector2&);

			/// gk
			virtual void Scaling(float x, float y);

			/// gk
			virtual void Scaling(const Blast::Math::Vector2&);


			/* ] */

			/// ]l擾
			virtual const Blast::Math::Vector3& GetRotation() const;

			/// ]l擾
			virtual Blast::Math::Vector3& GetRotation();

			/// ]lݒ
			virtual void SetRotation(float x, float y, float z);

			/// ]lݒ
			virtual void SetRotation(const Blast::Math::Vector3&);

			/// ]
			virtual void Rotate(float x, float y, float z);

			/// ]
			virtual void Rotate(const Blast::Math::Vector3&);


			/* _BTCYZôŁAɃTCYݒ肵ȂƃYĂ܂܂B */

			/// _擾
			virtual const Blast::Math::Vector2& GetOrigin() const;

			/// _擾
			virtual Blast::Math::Vector2& GetOrigin();


			/// _ݒ
			virtual void SetOrigin(float x, float y);

			/// _ݒ
			virtual void SetOrigin(const Blast::Math::Vector2&);

			/// _ݒ
			virtual void SetOrigin(EOrigin);


			/// _ړ
			virtual void MoveOrigin(float x, float y);

			/// _ړ
			virtual void MoveOrigin(const Blast::Math::Vector2&);


			/// UVWړ
			virtual void MoveUV(float moveU, float moveV);

			/// UVWړ
			virtual void MoveUV(const Blast::Math::Vector2&);


			/// MEMO:O瓮IɌĂ΂邱Ƃ̂publicɔzu܂B
			/// [hsXV
			void UpdateWorldMatrix();

			/// UVϊsXV
			void UpdateUIMatrix();


			//====================================================================================================
			// Property
			//----------------------------------------------------------------------------------------------------


			///// TODO:_̈ʒu̎ނݒ
			//void SetOrigin(EOrigin eOrigin)
			//{
			//	mEOrigin = eOrigin;
			//}


			// Fݒ
			void SetColor(Color& kRColor)
			{
				mColor = kRColor;
			}

			// F擾
			Color& GetColor()
			{
				return mColor;
			}

			// F擾
			const Color& GetColor() const
			{
				return mColor;
			}


			/// VF[_[擾
			SP<ShaderEffectDX9> GetShaderEffect()
			{
				return mPShaderEffect;
			}

			/// VF[_[擾
			const SP<ShaderEffectDX9> GetShaderEffect() const
			{
				return mPShaderEffect;
			}

			/// VF[_[ݒ
			void SetShaderEffect(SP<ShaderEffectDX9> pShader) { mPShaderEffect = pShader; }

			/// `tO擾
			bool IsVisible();
			/// `tOݒ
			void SetVisible(bool value);


#if _DEBUG
			//====================================================================================================
			// Debug
			//----------------------------------------------------------------------------------------------------

			/// \
			void DebugRender(int x, int y) const;

			/// o
			void DebugOutput() const;
#endif // _DEBUG

		private:
			/// bV
			SP<Blast::Graphic::MeshSpriteDX9> mPMesh;


			/// gk
			Blast::Math::Vector2 mScale;

			/// ʒu
			Blast::Math::Vector3 mPosition;

			/// ]l
			Blast::Math::Vector3 mRotation;


			/// [hs
			Blast::Math::Matrix mWorld;


			/// TCY
			Blast::Math::Vector2 mSize;

			/// _
			Blast::Math::Vector2 mOrigin;

			/// F
			Blast::Graphic::Color mColor;


			/// MEMO:^floatɂĂ܂A肪oint܂B
			/// ö
			Blast::Math::Rectangle<float> mSourceRectangle;

			/// UVϊs
			Blast::Math::Matrix mUVMatrix;


			/// J
			SP<Blast::Graphic::ICamera> mPCamera;


			/// 2DeNX`
			SP<Blast::Graphic::ITexture2D> mPTexture;


			/// VF[_[
			SP<Blast::Graphic::ShaderEffectDX9> mPShaderEffect;


			bool mIsVisible;	///< `tO
		};

	} // namespace Graphic
} // namespace Blast

#endif // BLAST_GRAPHIC_SPRITE3DDX9_H