#ifndef BLAST_GRAPHIC_SHADEREFFECTDX9_H
#define BLAST_GRAPHIC_SHADEREFFECTDX9_H

#include <vector>
#include "Blast/Graphic/IShaderEffect.h"
#include "Blast/Math/Matrix.h"

/*	HACK:
	D3DXHANDLE^œn̂́Ǎ^œnǂB
	nƏxȂ炵B
	͏D3DXHANDLEɂĂƗǂ炵B
*/

namespace Blast
{
	namespace Graphic
	{
		/// ITexturẽvg^Cv
		class ITexture;

		/// DirectX9p̃VF[_[GtFNg̏SNX
		class ShaderEffectDX9 : public Blast::Graphic::IShaderEffect
		{
			//====================================================================================================
			// Enumerate
			//----------------------------------------------------------------------------------------------------

		public:
			/// VF[_[GtFNg̎
			enum EShaderEffect
			{
				eSHADEREFFECT_STANDARD_CONSTANT,	///< {̃RX^gf
				eSHADEREFFECT_STANDARD_LAMBERT,		///< {̃o[gf
				eSHADEREFFECT_STANDARD_PHONG,		///< {̃tHf
				eSHADEREFFECT_STANDARD_PRIMITIVE,	///< {̃v~eBu
				eSHADEREFFECT_CHARACTER,			///< LN^[
				eSHADEREFFECT_LINE_3D,				///< 3DpC
				eSHADEREFFECT_GRID_3D,				///< 3DObh
				eSHADEREFFECT_CROSSHAIR,			///< NXwA
				eSHADEREFFECT_SPRITE2D,				///< XvCg2Dp
				eSHADEREFFECT_SPRITE3D,				///< XvCg3Dp
				eSHADEREFFECT_FADE,					///< tF[hp
				eSHADEREFFECT_EFFECTTECHNIQUES,		///< p
				eSHADEREFFECT_SKIN_ANIMATION,		///< XLAj[Vp

				// MEMO:KvȂ΂ɒǉłB

				/// 񋓗vf̐
				eSHADEREFFECT_COUNT,
			};

			/// O[oϐ̎
			enum EVariable
			{
				
				eVARIABLE_WORLD,					///< [hs
				eVARIABLE_VIEW,						///< r[s
				eVARIABLE_PROJECTION,				///< vWFNVs
				eVARIABLE_VIEWPORT,					///< r[|[gs
				eVARIABLE_UV_TRANSFORM,				///< UVϊs
				eVARIABLE_WORLD_INVERSE_TRANSPOSE,	///< t[h]us
				eVARIABLE_WORLD_VIEW_PROJECTION,	///< [hr[vWFNVs
				eVARIABLE_VIEW_INVERSE,				///< tr[s
				eVARIABLE_POSE,						///< |[Ys

				eVARIABLE_AMBIENT_COLOR,			///< ̐F
				eVARIABLE_DIFFUSE_COLOR,			///< gU˂̐F
				
				eVARIABLE_POINTLIGHT_POSITION,		///< _̈ʒu
				eVARIABLE_POINTLIGHT_COLOR,			///< _̐F

				eVARIABLE_SPECULAR,					///< XyL
				eVARIABLE_SPECULAR_POWER,			///< XyL̋

				eVARIABLE_BUMPINESS,				///< ovl

				eVARIABLE_REFLECTION_STRENGTH,		///< }bv̔ˋx
				
				eVARIABLE_INSTANCE_POSITIONS,		///< CX^XpʒuWz
				eVARIABLE_INSTANCE_VISIBLES,		///< CX^Xp`tOz

				eVARIABLE_DIFFUSE_TEXTURE,			///< fBt[YeNX`
				eVARIABLE_NORMAL_TEXTURE,			///< m[}eNX`
				eVARIABLE_ENVIROMENT_TEXTURE,		///< eNX`
				eVARIABLE_RULE_TEXTURE,				///< [eNX`

				eVARIABLE_CURRENT_POSE,				///< Jg|[Ys

				/// 񋓗vf̐
				eVARIABLE_COUNT,
			};

			/// eNjbN
			enum ETechnique
			{
				eTECHNIQUE_SOLID,				/// \bh
				eTECHNIQUE_WIREFRAME,			/// C[t[
				eTECHNIQUE_SOLID_WIREFRAME,		/// \bhƃC[t[
				eTECHNIQUE_WIREFRAME_ONLY,		/// C[t[̂

				eTECHNIQUE_CONSTANT,			/// RX^g
				eTECHNIQUE_CONSTANT_WIREFRAME,	/// RX^gƃC[t[

				eTECHNIQUE_LAMBERT,				/// o[g

				eTECHNIQUE_PHONG,				/// tH

				/// 񋓗vf̐
				eTECHNIQUE_COUNT,
			};


			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

		public:
			/// 񋓑̂ɑΉVF[_[GtFNg̃t@CpX擾
			static const TCHAR* const ToFilePath(EShaderEffect);

			/// 񋓑̂ɑΉVF[_[ϐ擾
			static const CHAR* const ToVariableName(EVariable);

			/// 񋓑̂ɑΉZ}eBNX擾
			static const CHAR* const ToSemanticsName();

			/// 񋓑̂ɑΉeNjbN擾
			static const CHAR* const ToTechniqueName(ETechnique);


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

		public:
			/// RXgN^
			ShaderEffectDX9();
			/// fXgN^
			virtual ~ShaderEffectDX9();

			/// VF[_[GtFNgǂݍ
			virtual bool Load(const TCHAR* const kPFullPath) override;
			/// VF[_[GtFNgǂݍ
			bool Load(EShaderEffect);
			
			/* MEMO:BegiñtO
			#define D3DXFX_DONOTSAVESTATE         (1 << 0)
			#define D3DXFX_DONOTSAVESHADERSTATE   (1 << 1)
			#define D3DXFX_DONOTSAVESAMPLERSTATE  (1 << 2)
			*/

			/// Jn
			virtual void Begin(unsigned* pOutPassCount, unsigned long flag = 0) override;
			/// I
			virtual void End() override;
			/// pXJn
			virtual void BeginPass(int) override;
			/// pXI
			virtual void EndPass() override;

			/// lݒ
			void SetValue(D3DXHANDLE, void* pData, unsigned size);
			/// lݒ
			void SetValue(EVariable, void* pData, unsigned size);

			/// float^zݒ
			void SetFloatArray(D3DXHANDLE, const FLOAT[], unsigned count);
			/// float^zݒ
			void SetFloatArray(EVariable, const FLOAT[], unsigned count);

			/// D3DXVECTOR4^zݒ
			void SetVectorArray(D3DXHANDLE, const D3DXVECTOR4[], unsigned count);
			/// D3DXVECTOR4^zݒ
			void SetVectorArray(EVariable, const D3DXVECTOR4[], unsigned count);

			/// float4x4ݒ
			void SetMatrix(D3DXHANDLE, const D3DXMATRIX*);
			/// Matrixݒ
			void SetMatrix(D3DXHANDLE, const Blast::Math::Matrix*);
			/// float4x4ݒ
			void SetMatrix(EVariable, const D3DXMATRIX*);
			/// Matrixݒ
			void SetMatrix(EVariable, const Blast::Math::Matrix*);

			/// float4x4z擾
			void GetMatrixArray(D3DXHANDLE, D3DXMATRIX*, unsigned count);
			/// float4x4z擾
			void GetMatrixArray(EVariable, D3DXMATRIX*, unsigned count);
			/// float4x4zݒ
			void SetMatrixArray(D3DXHANDLE, const D3DXMATRIX*, unsigned count);
			/// float4x4zݒ
			void SetMatrixArray(EVariable, const D3DXMATRIX*, unsigned count);

			/// boolݒ
			void SetBool(D3DXHANDLE, BOOL);
			/// boolݒ
			void SetBool(EVariable, BOOL);

			/// boolzݒ
			void SetBoolArray(D3DXHANDLE, BOOL[], unsigned count);
			/// boolzݒ
			void SetBoolArray(EVariable, BOOL[], unsigned count);

			/// Textureݒ
			void SetTexture(D3DXHANDLE, IDirect3DTexture9*);
			/// Textureݒ
			void SetTexture(EVariable, IDirect3DTexture9*);

			/// ύXʒm
			void CommitChanges();

			/// Z}eBNXϐ̃nh擾
			D3DXHANDLE GetParameterBySemantic(D3DXHANDLE level, LPCSTR name);

			/// eNjbN擾
			D3DXHANDLE GetTechnique(unsigned);
			/// eNjbNݒ
			void SetTechnique(D3DXHANDLE);
			/// eNjbNݒ
			void SetTechnique(int index);
			/// eNjbNݒ
			void SetTechnique(ETechnique);


			// ADD:ɂ낢

			
			//====================================================================================================
			// Property
			//----------------------------------------------------------------------------------------------------

		public:
			/// VF[_[GtFNg擾BconsttB
			const CSP<ID3DXEffect> GetShaderEffect() const;
			/// VF[_[GtFNg擾
			CSP<ID3DXEffect> GetShaderEffect();

			/// t@CpX擾
			const TCHAR* GetFilePath() const;

			/// BeginσtO擾
			bool IsBegan() const;
			
			
			//====================================================================================================
			// Field
			//----------------------------------------------------------------------------------------------------

		private:
			CSP<ID3DXEffect>	mPShaderEffect;	///< VF[_[GtFNg
			tstring				mFilePathStr;	///< t@CpX
			bool				mIsBegan;		///< BeginσtOBtrueȂBeginρAfalseȂ܂B
			
			/// VF[_[GtFNg̎ނɑΉtpX
			static const TCHAR* const stKPFullPaths[];

			/// O[oϐ̎ނɑΉϐQ
			static const CHAR* const stKPVariableNames[];

			/// eNjbN̎ނɑΉeNjbNQ
			static const CHAR* const stKPTechniqueNames[];
		};
	} // namespace Graphic
} // namespace Blast

#endif // BLAST_GRAPHIC_SHADEREFFECTDX9_H
