#ifndef BLAST_GRAPHIC_MESHOBJ_H
#define BLAST_GRAPHIC_MESHOBJ_H

#include "Blast/Graphic/DirectX9/MeshDX9.h"
#include "Blast/Graphic/DirectX9/VertexBufferDX9.h"
#include "Blast/Graphic/DirectX9/IndexBufferDX9.h"
#include "Blast/Graphic/DirectX9/VertexDeclarationDX9.h"
#include "Blast/Graphic/DirectX9/ShaderEffectDX9.h"
#include "Blast/Graphic/ITexture2D.h"


namespace Blast
{
	namespace Graphic
	{
		/// OBJ`̃bVێNX
		class MeshObjDX9 : public Blast::Graphic::MeshDX9
		{
		public:
			//====================================================================================================
			// Enumerate
			//----------------------------------------------------------------------------------------------------

			/// L[̎
			enum EKeyString
			{
				/// Rg
				eKEY_STRING_COMMENT,

				/// _ʒu
				eKEY_STRING_POSITION,

				/// UVW
				eKEY_STRING_UV,

				/// @
				eKEY_STRING_NORMAL,

				/// tFCX
				eKEY_STRING_FACE,

				/// }eAt@C
				eKEY_STRING_MATERIAL_FILENAME,

				/// gp}eA
				eKEY_STRING_USE_MATERIAL_NAME,

				/// }eA
				eKEY_STRING_MATERIAL_NAME,

				/// ArGg
				eKEY_STRING_AMBIENT,

				/// fBt[Y
				eKEY_STRING_DIFFUSE,

				/// XyL
				eKEY_STRING_SPECULAR,

				/// VClX
				eKEY_STRING_SHININESS,

				/// fBt[Y}bv
				eKEY_STRING_DIFFUSE_TEXTURE,


				/// 񋓗vf̐
				eKEY_STRING_COUNT,
			};

			/// _obt@̎
			enum EVertexBuffer
			{
				/// ʒu
				eVERTEXBUFFER_POSITION,

				/// UV
				eVERTEXBUFFER_UV,

				/// @
				eVERTEXBUFFER_NORMAL,


				/// 񋓗vf̐
				eVERTEXBUFFER_COUNT,
			};


			//====================================================================================================
			// Struct
			//----------------------------------------------------------------------------------------------------

			/// }eA
			struct SMaterial
			{
			public:
				/// }eA
				tstring mNameStr;

				/// ArGg
				Blast::Math::Vector3 mAmbient;

				/// fBt[Y
				Blast::Math::Vector3 mDiffuse;

				/// XyL
				Blast::Math::Vector3 mSpecular;

				/// VClX
				float mShininess;

				/// fBt[YeNX`
				SP<Blast::Graphic::ITexture2D> mPDiffuseTexture;


				/// v~eBu
				unsigned mPrimitiveCount;


				/// RXgN^
				SMaterial()
				{
					mNameStr = _T("");
					mAmbient = Blast::Math::Vector3::Zero();
					mDiffuse = Blast::Math::Vector3::Zero();
					mSpecular = Blast::Math::Vector3::Zero();
					mShininess = 0;

					mPrimitiveCount = 0;
				}

			private:
			};


			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// L[Q
			static const TCHAR* const mStKPKeyStrings[];


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			MeshObjDX9();

			/// fXgN^
			virtual ~MeshObjDX9();


			/// `
			virtual void Render();


			/// bVǂݍ
			bool Load(const TCHAR* kPFullPath);

		private:
			/// o[ebNXobt@Q
			SP<Blast::Graphic::VertexBufferDX9> mPVertexBuffers[eVERTEXBUFFER_COUNT];

			/// CfbNXobt@Q
			std::vector< SP<Blast::Graphic::IndexBufferDX9> > mPIndexBuffers;


			/// _`
			SP<Blast::Graphic::VertexDeclarationDX9> mPVertexDeclaration;


			/// }eAQ
			std::vector<SMaterial> mSMaterials;


			///// VF[_[GtFNg
			//SP<Blast::Graphic::ShaderEffectDX9> mPShaderEffect;

			
			//====================================================================================================
			// PrivateOperation
			//----------------------------------------------------------------------------------------------------

			/// }eAǂݍ
			void LoadMaterial(const TCHAR* kPFullPath);
		};

	} // namespace Graphic
} // namespace Blast

#endif // BLAST_GRAPHIC_MESHOBJ_H