#ifndef BLAST_GRAPHIC_FONTDX9_H
#define BLAST_GRAPHIC_FONTDX9_H

#include "Blast/Graphic/IFont.h"

namespace Blast
{
	namespace Graphic
	{
		/// DirectX9̃tHgێNX
		class FontDX9 : public Blast::Graphic::IFont
		{
			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

		public:
			/// ̃tHg
			static const TCHAR* const stKPFontName;

			/// ̃TCY
			static const int stKFontSize = 10;

			/// ̃EFCg
			static const int stKFontWeight = 500;


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

		public:
			/// RXgN^
			FontDX9();
			/// fXgN^
			virtual ~FontDX9();

			/// `
			virtual void Render() override;
			
			/// ̗̈̒擾
			virtual int MeasureString(const TCHAR* const) const override;

			/// tHgf[^쐬
			void CreateFontData(
				const TCHAR* kPFontName = stKPFontName,
				int size = stKFontSize,
				int weight = stKFontWeight
				);


			//====================================================================================================
			// Property
			//----------------------------------------------------------------------------------------------------

			/// tHg擾
			virtual const TCHAR* const GetFaceName() const override;

			/// |CgTCY擾
			virtual int GetPointSize() const override;

			/// EFCg擾
			virtual int GetWeight() const override;

			/// `悷ʒu擾
			virtual const Blast::Math::Vector3& GetPosition() const override;
			/// `悷ʒuݒ
			virtual void SetPosition(const Blast::Math::Vector3&) override;

			/// ]l擾
			virtual const Blast::Math::Vector3& GetRotation() const override;
			/// ]lݒ
			virtual void SetRotation(const Blast::Math::Vector3&) override;

			/// F擾
			virtual const Color& GetColor() const override;
			/// Fݒ
			virtual void SetColor(const Color&) override;

			/// `悷镶擾
			virtual const TCHAR* const GetText() const override;
			/// `悷镶ݒ
			virtual void SetText(const TCHAR* const) override;


			//====================================================================================================
			// Field
			//----------------------------------------------------------------------------------------------------

		private:
			tstring mFaceNameStr;	///< tHg
			int mPointSize;			///< |CgTCY
			int mWeight;			///< EFCg
			
			// MEMO:uJƕ`łȂH@ătHgɂ͑Ȃ񂶂ȂHvlƁAKvAsvȕϐ₷H
			Blast::Math::Vector3 mPosition;	///< ʒuB̃NXɂ͑ȂH
			Blast::Math::Vector3 mRotation;	///< ]B̃NXɂ͑ȂH
			Color mColor;		///< FB̃NXɂ͑ȂH
			tstring mTextStr;	///< B̃NXɂ͑ȂH

			/// DirectXptHg
			mutable CSP<ID3DXFont> mPFont;
		};

	}// namespace Graphic
}// namespace Blast

#endif // BLAST_GRAPHIC_FONTDX9_H