#ifndef BLAST_FRONTEND_MENU_H
#define BLAST_FRONTEND_MENU_H

#include <list>
#include "Blast/Frontend/IFEMenuEntry.h"

namespace PadInputTag
{
	enum EPadInputTag;
};

namespace Blast
{
	namespace Frontend
	{
		/// j[̏SNX
		class FEMenu
		{
			//====================================================================================================
			// Alias
			//----------------------------------------------------------------------------------------------------

		public:
			/// ڂ̃Xǧ^
			typedef std::list< SP<IFEMenuEntry> > ItemList;


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

		public:
			/// RXgN^
			FEMenu();
			/// fXgN^
			~FEMenu();

			/// 
			void Initialize();
			/// 
			void HandleInput(float delta);
			/// XV
			void Update(float delta);
			/// `
			void Render();

			/// ڂǉ
			void AddItem(SP<IFEMenuEntry> pItem);
			/// ڂO
			void RemoveItem(SP<IFEMenuEntry> pItem);

			/// ڂ̃Xg擾
			const ItemList* GetItems() const;
			/// ڂ̃Xg擾
			ItemList* GetItems();

			/// ڂ擾BCfbNXwB
			SP<IFEMenuEntry> GetItem(int index);
			/// ڂ擾BOwB
			SP<IFEMenuEntry> GetItem(const TCHAR*);

			/// IĂ鍀ڂ擾
			SP<IFEMenuEntry> GetSelectedItem();

			void Clear();	///< ڂNA
			bool IsEmpty();	///< ڂ1ǂ擾


			//====================================================================================================
			// Property
			//----------------------------------------------------------------------------------------------------

		public:
			/// O擾
			const TCHAR* GetName() const;
			/// Oݒ
			void SetName(const TCHAR* pValue);

			/// ͏tO擾
			bool IsInputable() const;
			/// ͏tOݒ
			void SetInputable(bool value);

			/// XVtO擾
			bool IsEnable() const;
			/// XVtOݒ
			void SetEnable(bool value);

			/// `揈tO擾
			bool IsVisible() const;
			/// `揈tOݒ
			void SetVisible(bool value);
			
			/// IĂCfbNX擾
			int GetSelectedIndex() const;
			/// IĂCfbNXݒ
			void SetSelectedIndex(int value);

			/// ڂ̕`Jnʒu擾
			const Blast::Math::Vector3& GetPosition() const;
			/// ڂ̕`Jnʒuݒ
			void SetPosition(const Blast::Math::Vector3& value);

			/// xɕ\鍀ڐ擾
			int GetDisplayCount() const;
			/// xɕ\鍀ڐݒ
			void SetDisplayCount(int value);

			/// \鍀ڂ̊JnCfbNX擾
			int GetDisplayStartIndex() const;
			/// \鍀ڂ̊JnCfbNXݒ
			void SetDisplayStartIndex(int value);

			/// sԂ擾
			float GetLineSpacing() const;
			/// sԂݒ
			void SetLineSpacing(float value);

			/// ͌ʂ擾
			PadInputTag::EPadInputTag GetInputResultTag() const;


			//====================================================================================================
			// Implement
			//----------------------------------------------------------------------------------------------------

		private:
			/// 
			void Construct();
			/// p
			void Destruct();

			/// O̍ڂI
			void SelectBack();
			/// ̍ڂI
			void SelectNext();


			//====================================================================================================
			// Field
			//----------------------------------------------------------------------------------------------------

		private:
			/// ڂ̃Xg
			ItemList	mItems;

			tstring		mNameStr;			///< O
			bool		mIsInputable;		///< ͉\ǂ
			bool		mIsEnable;			///< XV\ǂ
			bool		mIsVisible;			///< `\ǂ
			int			mSelectedIndex;		///< IĂ鍀ڂ̃CfbNX

			Blast::Math::Vector3 mPosition;	///< ڂ̕`Jnʒu	

			int		mDisplayCount;			///< xɕ\鍀ڐ
			int		mDisplayStartIndex;		///< \鍀ڂ̊JnCfbNX
			float	mLineSpacing;			///< s

			PadInputTag::EPadInputTag	mEInputResultTag;	///< ͌
	};

	} // namespace Frontend
} // namespace Blast

#endif  // BLAST_FRONTEND_MENU_H