#ifndef BLAST_DESIGN_SMARTPOINTER_H
#define BLAST_DESIGN_SMARTPOINTER_H

namespace Blast
{
	namespace Design
	{
		/// X}[g|C^NX
		template <class T>
		class SmartPointer
		{
		public:
			//====================================================================================================
			// Friend
			//----------------------------------------------------------------------------------------------------

			/// MEMO:AbvLXgAQƂƂɕKvłB
			friend class SmartPointer;


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			explicit SmartPointer(T* pSource = NULL, bool isArray = false) :
				mPSource(NULL),
				mPReferenceCount(NULL),
				mPIsArray(NULL)
			{
				Construct(pSource, isArray);
			}

			/// RXgN^
			explicit SmartPointer(T* pSource, u32* pReferenceCount, bool* pIsArray)
			{
				Copy(pSource, pReferenceCount, pIsArray);
			}

			/// Rs[RXgN^
			SmartPointer(const SmartPointer& rSource)
			{
				Copy(rSource);
			}

			/// fXgN^
			virtual ~SmartPointer()
			{
				Release();
			}


			/// |C^ݒ
			void SetPointer(T* pSource = NULL, bool isArray = false)
			{
				// MEMO:Ƀ|C^ێĂ邱ƂlAUReleaseR[Ă܂

				// QƃJE^炷Release
				Release();

				// ăRXgNg
				Construct(pSource, isArray);
			}


			/// _ELXg
			template <class U>
			bool DownCast(SmartPointer<U>& rSrc)
			{
				// _Ci~bNLXg
				T* pDC = dynamic_cast<T*>(rSrc.GetSource());

				// _Ci~bNLXgɐȂ
				if (pDC)
				{
					// Ⴄ|C^ɂȂ̂ŉ
					Release();

					// MEMO:|C^̂܂܎󂯎܂B
					// Rs[
					Copy(pDC, rSrc.GetReferenceCount(), rSrc.GetIsArray());

					return true;
				}
				// LXgɎsȂ
				else
				{
					// Ⴄ|C^ɂȂ̂ŉ
					Release();

					// RXgNg
					Construct(NULL, false);

					return false;
				}
			}


			//====================================================================================================
			// Property
			//----------------------------------------------------------------------------------------------------

			/// |C^擾
			T* GetSource()
			{
				return mPSource;
			}

			/// |C^擾
			const T* GetSource() const
			{
				return mPSource;
			}


			/// QƃJE^̃|C^擾
			u32* GetReferenceCount()
			{
				return mPReferenceCount;
			}

			/// QƃJE^̃|C^擾
			const u32* GetReferenceCount() const
			{
				return mPReferenceCount;
			}


			/// z񂩂ǂ̃|C^擾
			bool* GetIsArray()
			{
				return mPIsArray;
			}

			/// z񂩂ǂ̃|C^擾
			const bool* GetIsArray() const
			{
				return mPIsArray;
			}


			//====================================================================================================
			// Overload
			//----------------------------------------------------------------------------------------------------

			/// Zqgē^Rs[ł悤
			SmartPointer& operator= (const SmartPointer<T>& rSource)
			{
				// |C^Ȃ牽Ȃ
				if (mPSource == rSource.mPSource)
				{
					return (*this);
				}

				// ̎QƃJE^炷
				Release();

				// Rs[
				Copy(rSource);

				return (*this);
			}

			/// ZqgĖAbvLXgs悤
			template <class U>
			SmartPointer& operator= (SmartPointer<U>& pSuperSource)
			{
				// ̎QƃJE^炷
				Release();

				// Rs[
				Copy(pSuperSource);

				return (*this);
			}


			/// MEMO:if̒ɓۂɕ֗łB
			/// |C^NULLǂ𔻒f\ɂ
			operator bool() const
			{
				// MEMO:ژ_lԂƌxôŁA򏈗ŕԂ܂B
				// |C^LȂ
				if (mPSource)
				{
					return true;
				}
				else
				{
					return false;
				}
			}


			/// PZq!ł̕]\ɂ
			bool operator! () const
			{
				return (!mPSource);
			}


			/// rZqŃAhXǂ𔻒fł悤
			bool operator== (int address)
			{
				return (mPSource == address);
			}

			/// rZqŃAhXǂ𔻒fł悤
			bool operator==(SmartPointer<T> sp)
			{
				return (mPSource == sp.GetSource());
			}


			/// rZqŃAhXႤǂ𔻒fł悤
			bool operator!= (int address)
			{
				return (mPSource != address);
			}


			/// A[Zqœ|C^ւ̃ANZX\ɂ
			inline T* operator-> ()
			{
				return mPSource;
			}

			/// A[Zqœ|C^ւ̃ANZX\ɂ
			inline const T* operator-> () const
			{
				return mPSource;
			}


			/// ֐ߎQƉZqŎ̂ւ̎QƃANZX\ɂ
			T& operator* ()
			{
				return *mPSource;
			}

			/// ֐ߎQƉZqŎ̂ւ̎QƃANZX\ɂ
			const T& operator* () const
			{
				return *mPSource;
			}


			/// zYZqł̃ANZX\ɂ
			T& operator[] (int index)
			{
				return mPSource[index];
			}
			
			/// zYZqł̃ANZX\ɂ
			const T& operator[] (int index) const
			{
				return mPSource[index];
			}


			/// MEMO:X}[g|C^m̑ɂÖق̃AbvLXg\ɂ܂B
			/// NXւ̃LXgs
			template<class U>
			operator SmartPointer<U>()
			{
				// X}[g|C^쐬
				SmartPointer<U> sp(mPSource, mPReferenceCount, mPIsArray);

				return sp;
			}


	#if _DEBUG

			//====================================================================================================
			// Debug
			//----------------------------------------------------------------------------------------------------

			/// o
			void DebugOutputSmartPointer() const
			{
				PFL(_T("AhX->%08x, QƃJE^->%2u(%08x), z񂩂ǂ->%5s"),
					mPSource,
					*mPReferenceCount,
					mPReferenceCount,
					*mPIsArray ? _T("True") : _T("False")
					);
			}

	#endif // _DEBUG

		private:
			/// |C^
			T* mPSource;

			// MEMO:Iɗ̈mۂĕێ܂
			/// QƃJE^
			u32* mPReferenceCount;

			/// |C^̏񂪔z񂩂ǂ
			bool* mPIsArray;


			//====================================================================================================
			// PrivateOperation
			//----------------------------------------------------------------------------------------------------
			
			/// RXgNg
			void Construct(T* pSource, bool isArray)
			{
				mPSource = pSource;

				mPReferenceCount = new u32();
				*mPReferenceCount = 0;

				mPIsArray = new bool();
				*mPIsArray = isArray;

				// QƃJE^𑝂₷
				Add();
			}


			/// Rs[
			void Copy(T* pSource, u32* pReferenceCountPtr, bool* pIsArray)
			{
				// MEMO:e|C^̂܂܎󂯎܂B
				mPSource = pSource;
				mPReferenceCount = pReferenceCountPtr;
				mPIsArray = pIsArray;

				// QƃJE^𑝂₷
				Add();
			}

			// MEMO:AbvLXgɑΉ邽߁Aev[ǧ^͕ʓr߂Ē`Ă܂
			/// Rs[
			template <class U>
			void Copy(const SmartPointer<U>& rSource)
			{
				// MEMO:Ɠ^Ȃ̂ŕϐɒڃANZX\ł

				// Ⴂ܂
				mPSource = rSource.mPSource;
				mPReferenceCount = rSource.mPReferenceCount;
				mPIsArray = rSource.mPIsArray;

				// QƃJE^𑝂₷
				Add();
			}


			/// QƃJE^Z
			void Add()
			{
				++(*mPReferenceCount);
			}

			/// QƃJE^Z
			void Release()
			{
				--(*mPReferenceCount);

				// QƃJE^0Ȃj
				if (*mPReferenceCount == 0)
				{
					// MEMO:deleteZq͑O錾̃NXɑ΂Čʂ̂ŁAʃNXɂȂƂȂB

					// zȂ
					if (*mPIsArray)
					{
						delete[] mPSource;
						mPSource = NULL;
					}
					// zł͖Ȃ
					else
					{
						delete mPSource;
						mPSource = NULL;
					}

					delete mPReferenceCount;
					mPSource = NULL;

					delete mPIsArray;
					mPSource = NULL;
				}
			}
		};

	} // namespace Design
} // namespace Blast

#endif // BLAST_DESIGN_SMARTPOINTER_H