#ifndef BLAST_DESIGN_MODETRANSISTOR_H
#define BLAST_DESIGN_MODETRANSISTOR_H

#include <map>


namespace Blast
{
	namespace Design
	{
		/// switchɂԑJڋ@\󂯂NX
		template <class T>
		class ModeTransistor
		{
			//====================================================================================================
			// Struct
			//----------------------------------------------------------------------------------------------------

		private:
			/// 1̏֐Q
			struct SWorkMethod
			{
				/// RXgN^
				SWorkMethod()
				{
					mPOn = NULL;
					mPOff = NULL;
					mPHandleInput = NULL;
					mPUpdate = NULL;
					mPRender = NULL;
				}


				///< Jn\bh
				void (T::*mPOn)();

				///< I\bh
				void (T::*mPOff)();

				/// ̓\bh
				void (T::*mPHandleInput)(float);

				/// XV\bh
				void (T::*mPUpdate)(float);

				/// `惁\bh
				void (T::*mPRender)();
			};

			//====================================================================================================
			// Alias
			//----------------------------------------------------------------------------------------------------

		private:
			/// [hƏ֐Q̔z
			typedef std::map<int, SWorkMethod> WorkMethodList;

			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

		public:
			/// RXgN^
			ModeTransistor()
			{
				Construct();
			}
			/// RXgN^BƓɃNXw肷B
			ModeTransistor(T* pHandle)
			{
				Construct();
				Initialize(pHandle);
			}

			/// fXgN^
			~ModeTransistor() { }


			/// B
			/// RXgN^ŃNXw肵ȂꍇÅ֐ŃNXw肷KvB
			void Initialize(T* pHandle);

			/// ͏s
			void HandleInput(float delta);

			/// XVs
			void Update(float detla);

			/// `揈s
			void Render();

			/// ֐ǉ
			void Add(
				int mode,
				void (T::*pOn)(),
				void (T::*pOff)(),
				void (T::*pHandleInput)(float delta),
				void (T::*pUpdate)(float delta),
				void (T::*pRender)()
				);

			/// ԂύX
			void ChangeMode(int mode);

			/// ݂̏Ԃ擾
			int GetCurrentMode() const;

			/// ݂̏Ԃƈv邩𔻒肷
			bool IsCurrentMode(int mode) const;


			//====================================================================================================
			// Implement
			//----------------------------------------------------------------------------------------------------

		private:
			/// 
			void Construct()
			{
				mPHandle = NULL;
				mCurrentMode = -1;
			}

			/// Jns
			void On();

			/// Is
			void Off();

			
			//====================================================================================================
			// Field
			//----------------------------------------------------------------------------------------------------

		private:
			/// NX̃nh
			T* mPHandle;

			/// ݂̃[h
			int mCurrentMode;

			/// ݂̃[h̏֐
			SWorkMethod mSCurrentWorkMethod;

			/// [hƂ̏֐Q
			WorkMethodList mSWorkMethods;
		};

	
		//====================================================================================================
		// Implement
		//----------------------------------------------------------------------------------------------------

		/// 
		template <class T>
		void ModeTransistor<T>::Initialize(T* pHandle)
		{
			mPHandle = pHandle;
		}

		/// Jns
		template <class T>
		void ModeTransistor<T>::On()
		{
			ASSERT_PF(mPHandle, _T("nhNULLłB"));
			if (mPHandle && mSCurrentWorkMethod.mPOn)
			{
				(mPHandle->*mSCurrentWorkMethod.mPOn)();
			}
		}

		/// Is
		template <class T>
		void ModeTransistor<T>::Off()
		{
			ASSERT_PF(mPHandle, _T("nhNULLłB"));
			if (mPHandle && mSCurrentWorkMethod.mPOff)
			{
				(mPHandle->*mSCurrentWorkMethod.mPOff)();
			}
		}

		/// ͏s
		template <class T>
		void ModeTransistor<T>::HandleInput(float delta)
		{
			ASSERT_PF(mPHandle, _T("nhNULLłB"));
			if (mPHandle && mSCurrentWorkMethod.mPHandleInput)
			{
				(mPHandle->*mSCurrentWorkMethod.mPHandleInput)(delta);
			}
		}

		/// XVs
		template <class T>
		void ModeTransistor<T>::Update(float delta)
		{
			ASSERT_PF(mPHandle, _T("nhNULLłB"));
			if (mPHandle && mSCurrentWorkMethod.mPUpdate)
			{
				(mPHandle->*mSCurrentWorkMethod.mPUpdate)(delta);
			}
		}

		/// `揈s
		template <class T>
		void ModeTransistor<T>::Render()
		{
			ASSERT_PF(mPHandle, _T("nhNULLłB"));
			if (mPHandle && mSCurrentWorkMethod.mPRender)
			{
				(mPHandle->*mSCurrentWorkMethod.mPRender)();
			}
		}

		/// ֐ǉ
		template <class T>
		void ModeTransistor<T>::Add(
			int mode,
			void (T::*pOn)(),
			void (T::*pOff)(),
			void (T::*pHandleInput)(float),
			void (T::*pUpdate)(float),
			void (T::*pRender)()
			)
		{
			SWorkMethod sWM;
			sWM.mPOn = pOn;
			sWM.mPOff = pOff;
			sWM.mPHandleInput = pHandleInput;
			sWM.mPUpdate = pUpdate;
			sWM.mPRender = pRender;

			WorkMethodList::value_type pair(mode, sWM);
			mSWorkMethods.insert(pair);
		}

		/// ԂύX
		template <class T>
		void ModeTransistor<T>::ChangeMode(int mode)
		{
			// ԂȂ猻݂̏֐|C^ւ
			WorkMethodList::iterator it = mSWorkMethods.find(mode);
			ASSERT_PF(it != mSWorkMethods.end(),
				_T("o^̏Ԃ֑Jڂ悤Ƃ܂B\nJڐ̏ԂӐ}Ȃ̂AYꂸɓo^sĂ邩mFĂB\n\t݂̏=%dAJڐ̏=%d"), mCurrentMode, mode);
			if (it != mSWorkMethods.end())
			{
				SWorkMethod& rSWM = (*it).second;

				// ݂̏ԂƓȂ珈Ȃ
				if (mode == mCurrentMode)
				{
					return;
				}

				// ɏIsĂJڐ̊Jns
				ASSERT_PF(mPHandle, _T("nh܂BInitializeŐݒ肵ĂB"));
				if (mPHandle && mSCurrentWorkMethod.mPOff)
				{
					(mPHandle->*mSCurrentWorkMethod.mPOff)();
				}
				if (mPHandle && rSWM.mPOn)
				{
					(mPHandle->*rSWM.mPOn)();
				}

				PFL(_T("[hύXB %d%d"), mCurrentMode, mode);
				mCurrentMode = mode;
				mSCurrentWorkMethod = rSWM;
			}
		}

		/// ݂̏Ԃ擾
		template <class T>
		int ModeTransistor<T>::GetCurrentMode() const
		{
			return mCurrentMode;
		}
	
		/// ݂̏Ԃƈv邩𔻒肷
		template <class T>
		bool ModeTransistor<T>::IsCurrentMode(int mode) const
		{
			return (mCurrentMode == mode);
		}

	} // namespace Design
} // namespace Blast

#endif // BLAST_DESIGN_MODETRANSISTOR_H