#ifndef BLAST_BASE_SEQUENCEMANAGER_H
#define BLAST_BASE_SEQUENCEMANAGER_H

#include <vector>
#include "Blast/Design/Singleton.h"


namespace Blast
{
	namespace Base
	{
		/// ISequencẽvg^Cv
		class ISequence;


		/// V[PXǗVOgNX
		class SequenceManager : public Blast::Design::Singleton<SequenceManager>
		{
		public:
			//====================================================================================================
			// Alias
			//----------------------------------------------------------------------------------------------------

			/// V[PX̔ž^
			typedef std::vector< SP<ISequence> > Sequences;


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			SequenceManager();

			/// fXgN^
			~SequenceManager();


			/// 
			void HandleInput(float delta);

			/// XV
			void Update(float delta);

			/// `
			void Render();


			/// V[PXǉ
			void AddSequence(SP<ISequence>);

			/// V[PXO
			void RemoveSequence(SP<ISequence>);

			/// V[PX擾
			SP<ISequence> GetSequenceAt(int index);

			/// V[PX擾
			SP<ISequence> GetSequence(int type);

			/// V[PX̐擾
			int GetSequenceCount() const;

		private:
			/// V[PX̔z
			Sequences mSequences;
		};

	} // namespace Base
} // namespace Blast

#endif // BLAST_BASE_SEQUENCEMANAGER_H