#ifndef BLAST_BASE_SEQUENCEBASE_H
#define BLAST_BASE_SEQUENCEBASE_H

#include "Blast/Base/ISequence.h"
#include "Blast/Base/ISequenceUserData.h"
#include "Blast/Base/Menu.h"
#include "Blast/Base/GameComponentContainer.h"


namespace Blast
{
	namespace Base
	{
		/// V[PX̕WIȋ@\SX[p[NX
		class SequenceBase : public Blast::Base::ISequence
		{
		public:
			//====================================================================================================
			// Enumerate
			//----------------------------------------------------------------------------------------------------

			/// UNDONE:ModeTransistorpӂꂽ̂ŁAuƗǂȂH
			/// Jڏ
			enum ETransitionState
			{
				/// ANeBu
				eTRANSITION_STATE_ACTIVE,

				/// lKeBu
				eTRANSITION_STATE_NEGATIVE,

				/// ANeBu֑Jڒ
				eTRANSITION_STATE_ON,

				/// lKeBu֑Jڒ
				eTRANSITION_STATE_OFF,


				/// 񋓗vf̐
				eTRANSITION_STATE_COUNT,
			};


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^B
			/// V[PXׂœńAISequenceUserDatapNXpӂĈɓnĂB
			SequenceBase(bool isPopup = false, SP<ISequenceUserData> pUserData = SP<ISequenceUserData>());

			/// fXgN^
			virtual ~SequenceBase();


			/// 
			virtual void Initialize();

			/// ŏI
			virtual void Finalize();

			/// ͏
			virtual void HandleInput(float delta);

			/// XV
			virtual void Update(float delta);

			/// `
			virtual void Render();


			/// XVLǂ擾
			virtual bool IsEnable() const { return mIsEnable; }

			/// XVtOݒ
			void SetIsEnable(bool isValue) { mIsEnable = isValue; }

			/// `悷邩ǂ擾
			virtual bool IsVisible() const { return mIsVisible; }

			/// `tOݒ
			void SetIsVisible(bool isValue) { mIsVisible = isValue; }

			/// IĂ邩ǂ擾
			virtual bool IsExit() const { return mIsExit; }
			
			/// |bvAbvǂ擾
			virtual bool IsPopUp() const { return mIsPopUp; }

			
			/// ʂ̌^擾
			virtual int GetType() const { return -1; }


			/// [U[擾
			SP<ISequenceUserData> GetUserData() { return mPUserData; }

			// MEMO:ȂȂB
			///// [U[ݒ
			//void SetUserData(SP<ISequenceUserData> pUserData) { mPUserData = pUserData; }


			/// I
			void Exit();

			// MEMO:0.0ŃlKeBuA1.0ŃANeBułB
			/// JڏԂ̑Jڈʒu擾
			double GetTransitionPosition() const
			{
				return mTransitionPosition;
			}

		protected:
			bool mIsEnable;		///< XV̗LtO
			bool mIsVisible;	///< `̗LtO
			bool mIsExit;		///< IĂ邩ǂ̃tO
			bool mIsPopUp;		///< |bvAbvǂ̃tO

			/// oߎ
			double mElapsedTime;

			/// Jڏ
			ETransitionState mETransitionState;

			/// Jڈʒu
			double mTransitionPosition;

			/// ANeBu܂ł̑Jڎ
			double mTransitionOnTime;

			/// lKeBu܂ł̑Jڎ
			double mTransitionOffTime;

			/// lKeBuJňoߎ
			double mTransitionOffStartTime;

			/// [U[
			SP<ISequenceUserData> mPUserData;

			/// Q[R|[lg̃Rei
			SP<GameComponentContainer> mPGameComponents;

#if _DEBUG
			/// MEMO:Ă݂̂͂ǂł傤B
			/// fobOj[
			SP<Menu> mPDebugMenu;

			/// fobOj[̗LAtO
			bool mIsDebugEnable;
#endif // _DEBUG


			//====================================================================================================
			// PrivateOperation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			void Construct(bool isPopup, SP<ISequenceUserData> pUserData = SP<ISequenceUserData>());
		};

	} // namespace Base
} // namespace Blast

#endif // BLAST_BASE_SEQUENCEBASE_H