#ifndef BLAST_BASE_RESOURCEMANAGER_H
#define BLAST_BASE_RESOURCEMANAGER_H

#include <map>
#include "Blast/Design/Singleton.h"
#include "Blast/Base/IResource.h"


namespace Blast
{
	namespace Base
	{
		/// \[XǗNX
		class ResourceManager : public Blast::Design::Singleton<ResourceManager>
		{
		public:
			//====================================================================================================
			// Alias
			//----------------------------------------------------------------------------------------------------

			/// MEMO:L[̓̕nbVŎƍłB
			/// f\[X̃}bv
			typedef std::map<tstring, SP<Blast::Base::IResource>> ResourceMap;


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			ResourceManager();
			
			/// fXgN^
			virtual ~ResourceManager();


			/// XV
			void Update(float);


			/// ǂݍ
			template<class T>
			SP<T> Load(const TCHAR* const kPFullPath)
			{
				// Ƀ}bvĂ邩TAȂԂB
				ResourceMap::iterator it = mResourceMap.find(kPFullPath);
				if (it != mResourceMap.end())
				{
					SP<T> p;
					p.DownCast(it->second);

					return p;
				}
			
			
				// ȂVKɓǂݍ
				SP<T> pRes(NEW T());
				bool isSuccess = pRes->Load(kPFullPath);

				// ASSERT:Ȃ痎Ƃ
				ASSERT_PF(isSuccess, _T("\[X̓ǂݍ݂Ɏs܂B\nt@CpX=%s"), kPFullPath);
			
				// }bvɒǉ
				ResourceMap::value_type pair(kPFullPath, pRes);
				mResourceMap.insert(pair);
			
				return pRes;
			}

		private:
			/// \[X̃}bv
			ResourceMap mResourceMap;

			
			//====================================================================================================
			// PrivateOperation
			//----------------------------------------------------------------------------------------------------

			/// MEMO:QƃJE^1̂̂܂B
			/// gpĂȂ\[X
			void ReleaseUnusedResources();
		};
	} // namespace Base
} // namespace Blast

#endif // BLAST_BASE_RESOURCEMANAGER_H