#ifndef BLAST_BASE_DEBUGMENUENTRYLISTMATRIX_H
#define BLAST_BASE_DEBUGMENUENTRYLISTMATRIX_H

#include <vector>
#include "Blast/Base/IMenuEntryList.h"
#include "Blast/Graphic/TextRendererColorTag.h"


namespace Blast
{
	namespace Base
	{
		/// sɃGg[\NX
		class MenuEntryListMatrix : public Blast::Base::IMenuEntryList
		{
		public:
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			MenuEntryListMatrix();

			/// fXgN^
			virtual ~MenuEntryListMatrix();


			/// 
			virtual void HandleInput(float delta);

			/// XV
			virtual void Update(float delta);

			/// `
			virtual void Render();


			/// Gg[ǉ
			virtual void AddMenuEntry(SP<Blast::Base::IMenuEntry>);

			/// Gg[O
			virtual void RemoveMenuEntry(SP<Blast::Base::IMenuEntry>);


			/// Gg[擾
			virtual SP<Blast::Base::IMenuEntry> GetMenuEntry(const TCHAR* const kPName) const;

			/// I𒆂̃Gg[擾
			virtual SP<Blast::Base::IMenuEntry> GetSelectedMenuEntry() const;


			/// Gg[̐擾
			virtual int GetEntryCount() const;


			/// O擾
			virtual const TCHAR* const GetName() const;

			/// Oݒ
			virtual void SetName(const TCHAR* const);


			/// IĂCfbNX擾
			virtual int GetSelectedIndex() const;

			/// IĂCfbNXݒ
			virtual void SetSelectedIndex(int);


			/// ʒu擾
			virtual const Blast::Math::Vector3& GetPosition() const;

			/// ʒuݒ
			virtual void SetPosition(const Blast::Math::Vector3&);


			/// O̐F擾
			virtual const Blast::Graphic::Color& GetNameColor() const;

			/// O̐Fݒ
			virtual void SetNameColor(const Blast::Graphic::Color&);


			/// Jݒ
			virtual void SetCamera(const SP<Blast::Graphic::ICamera>);


			/// ܂ԂGg̐ݒ
			void SetFoldingEntryCount(int);


			//====================================================================================================
			// Transfar
			//----------------------------------------------------------------------------------------------------

			/// tHgݒ
			void SetFont(SP<Blast::Graphic::IFont>);

		private:
			/// O
			tstring mNameStr;

			/// O̐F
			Blast::Graphic::Color mNameColor;


			/// Gg[̔z
			std::vector< SP<IMenuEntry> > mEntries;

			/// Gg[̊Ԋu
			int mLineSpacing;

			/// IĂCfbNX
			int mSelectedIndex;


			/// ʒuW
			Blast::Math::Vector3 mPosition;

			
			/// eLXg_[
			SP<Blast::Graphic::TextRendererColorTag> mPTextRenderer;


			/// ܂Ԃ܂ł̃Gg[
			int mFoldingEntryCount;
		};

	} // namespace Base
} // namespace Blast

#endif // BLAST_BASE_DEBUGMENUENTRYLISTMATRIX_H