#ifndef BLAST_BASE_FRAMEPARSECONDFIXATION_H
#define BLAST_BASE_FRAMEPARSECONDFIXATION_H

#include <list>
#include "Blast/Base/IFrameParSecond.h"


namespace Blast
{
	namespace Base
	{
		/// ŒFPS̋NX
		class FrameParSecondFixation : public Blast::Base::IFrameParSecond
		{
		public:
			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// FPS̏l
			static const int mStKInitialFPS = 60;

			
			//====================================================================================================
			// Struct
			//----------------------------------------------------------------------------------------------------

			/// 
			struct SProperty
			{
			public:
				//====================================================================================================
				// Operation
				//----------------------------------------------------------------------------------------------------

				/// RXgN^
				SProperty();

				/// 
				void Initialize();

				/// XV
				void Update();


#ifdef _DEBUG
				//====================================================================================================
				// Debug
				//----------------------------------------------------------------------------------------------------

				/// p[^[`
				void DebugRender(int x, int y);

#endif // _DEBUG

				
				//====================================================================================================
				// Field
				//----------------------------------------------------------------------------------------------------

				/// t[[g
				int mFramerate;

				/// SPF
				double mMillSPF;

				/// ݂̃JE^
				u64 mCurrentCounter;

				/// ҋ@
				double mWaitMillTime;

				/// ŌɍXṼJE^
				u64 mLastCounter;

				/// NbNg
				u64 mFrequency;

				/// \ȃt[ǂ
				bool mIsAllowedFrame;

			private:
				//====================================================================================================
				// PrivateOperation
				//----------------------------------------------------------------------------------------------------

				/// g
				void InitializeFrequency();
				
				/// ݂̃JE^擾
				u64 GetCurrentCounter() const;
				
				/// Ԃ擾
				double GetMillDifferenceTimeFromLast();
			
				/// ̑ҋ@Ԃݒ
				void SetWaitTime();
			};


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			FrameParSecondFixation();

			/// fXgN^
			virtual ~FrameParSecondFixation();

			/// XV
			virtual void Update();

			/// Ԃ擾
			virtual double GetDeltaTime() const;

			/// FPSݒ
			virtual void SetFPS(int);

			/// \ȃt[ǂ擾
			virtual bool IsAllowedFrame();

			/// 
			void Initialize();


			//====================================================================================================
			// Property
			//----------------------------------------------------------------------------------------------------

			/// vpeB擾
			const SProperty& GetPropertyRef() const
			{
				return mSProperty;
			}

			
#ifdef _DEBUG
			//====================================================================================================
			// Debug
			//----------------------------------------------------------------------------------------------------

			/// `
			void DebugRender(int x, int y);
#endif // _DEBUG
			
		private:
			/// ̃vpeB
			SProperty mSProperty;
		};

	} // namespace Base
} // namespace Blast

#endif // BLAST_BASE_FRAMEPARSECONDFIXATION_H
