#ifndef BLAST_BASE_CONTAINER_H
#define BLAST_BASE_CONTAINER_H

#include <vector>

namespace Blast
{
	namespace Base
	{
		/// ReiNX
		template <class T>
		class Container
		{
		public:
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			Container()
			{
			}

			/// fXgN^
			virtual ~Container()
			{
			}


			/// ɒǉ
			void PushBack(T value)
			{
				mContainer.push_back(value);
			}

			/// O
			void PopBack()
			{
				mContainer.pop_back();
			}

			
			/// vf擾
			int GetCount() const
			{
				return mContainer.size();
			}


			/// vf󂩂ǂ擾
			bool IsEmpty() const
			{
				return mContainer.empty();
			}


			/// CfbNX͈͊Oǂ擾
			bool IsOutOfRange(int index)
			{
				const int kCount = GetCount();

				if (0 <= index && index < kCount)
				{
					return false;
				}
				else
				{
					return true;
				}
			}


			/// vfNA
			void Clear()
			{
				mContainer.clear();
			}


			/// YŃANZX\
			T& operator[](int index)
			{
				// ASSERT:͈͊OȂ玀
				ASSERT_PF(!IsOutOfRange(index), _T("Y͈͊OłBY=%d"), index);

				return mContainer.at(index);
			}
			
		private:
			/// Rei
			std::vector<T> mContainer;
		};

	} // namespace Base
} // namespace Blast

#endif // BLAST_BASE_CONTAINER_H