#ifndef BLAST_AUDIO_PCMPLAYERDX8_H
#define BLAST_AUDIO_PCMPLAYERDX8_H

#include "Blast/Audio/IAudioPlayer.h"
#include "Blast/Audio/IAudioDecoder.h"


namespace Blast
{
	namespace Audio
	{
		/// DirectSoundgĉ炷@\SNX
		class AudioPCMPlayerDX8 : public Blast::Audio::IAudioPlayer
		{
		public:
			//====================================================================================================
			// Enumerate
			//----------------------------------------------------------------------------------------------------

			/// Đ
			enum EState
			{
				/// 
				eSTATE_NONE,

				/// Đ
				eSTATE_PLAY,

				/// |[Y
				eSTATE_PAUSE,

				/// ~
				eSTATE_STOP,


				/// 񋓗vf̐
				eSTATE_COUNT,
			};

		public:
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			AudioPCMPlayerDX8();

			/// RXgN^
			AudioPCMPlayerDX8(CSP<IDirectSound8>);

			/// RXgN^
			AudioPCMPlayerDX8(CSP<IDirectSound8>, SP<IAudioDecoder>);

			// fXgN^
			~AudioPCMPlayerDX8();


			/// foCXݒ
			void SetDevice(CSP<IDirectSound8> cpDS8);


			/// Đ
			virtual bool Play(bool isLoop);

			/// ꎞ~
			virtual void Pause();

			/// ~
			virtual void Stop();


			/// Đǂ擾
			virtual bool IsPlaying() const;
			
			/// ꎞ~ǂ
			virtual bool IsPause() const;

			/// MEMO:[vꍇ͏falsełB
			/// Ō܂ōĐ
			virtual bool IsEnd() const;

			/// [v邩ǂ
			virtual bool IsLoop() const;


			/// PCMfR[_ݒ
			virtual bool SetDecoder(SP<IAudioDecoder> pcmDecoder);


			/// ʂݒ
			virtual void SetVolume(int);

			/// MEMO:}CiXl < 0 > vXl
			/// p̈ʒuݒ
			virtual void SetPan(int);


			/// NA
			virtual void Clear();

		private:
			//====================================================================================================
			// PrivateOperation
			//----------------------------------------------------------------------------------------------------

			/// Đ̃Xbh~
			void TerminateThread();

			/// obt@
			bool InitializeBuffer();

			/// Xg[ĐXbh
			static void __cdecl StreamThread( void* player );

			/// ǂ擾
			bool IsReadyOk() const;

			/// Ԏ擾
			EState GetState() const;

		private:
			//====================================================================================================
			// PrivateField
			//----------------------------------------------------------------------------------------------------

			/// ĐΏۃfR[h
			SP<IAudioDecoder> mPPCMDecoder;


			/// WAVEFORMATEX\
			WAVEFORMATEX mSWaveFormat;

			/// DSBUFFERDESC\
			DSBUFFERDESC mSDSBufferDesc;

			/// TEhfoCX
			CSP<IDirectSound8> mPDirectSound8;

			/// ZJ_obt@
			CSP<IDirectSoundBuffer8> mPDSBuffer;


			/// ǂ
			bool mIsReadyOk;


			/// Xg[ĐXbhnh
			unsigned int mStreamThreadHandle;

			/// Xbh~ǂ
			bool mIsTerminating;


			/// [v邩ǂ
			bool mIsLoop;

			/// Đ
			EState mEState;
		};

	} // namespace Audio
} // namespace Blast

#endif // BLAST_AUDIO_PCMPLAYERDX8_H