﻿Namespace Iterator.Core

    Public Class BookShelfEnumerator
        Implements IEnumerator

        Private _bookShelf As BookShelf
        Private _index As Integer = -1

        Public Sub New(ByVal bookShelf As BookShelf)
            _bookShelf = bookShelf
        End Sub

        Public ReadOnly Property Current() As Object Implements IEnumerator.Current
            Get
                Return _bookShelf.Book(_index)
            End Get
        End Property

        Public Function MoveNext() As Boolean Implements IEnumerator.MoveNext
            If (_index < _bookShelf.Length - 1) Then
                _index += 1
                Return True
            Else
                Return False
            End If
        End Function

        Public Sub Reset() Implements IEnumerator.Reset
            _index = -1
        End Sub

    End Class

End Namespace


