﻿Imports System.Windows.Forms

Public Class frmOperation

#Region "初期処理"

    Public Property frmView As frmView
    Public Property axPDF As AxAcroPDFLib.AxAcroPDF

    Private Sub Form2_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        screenDetect()
        AppSettingLoad()
    End Sub


#Region "設定値"
    Private Sub AppSettingLoad()

        cmbDisplay.SelectedIndex = My.Settings.cmbDisplaySelectedIndex
        cmbView.SelectedIndex = My.Settings.cmbView
    End Sub

    Private Sub AppSettingSave()

        My.Settings.cmbDisplaySelectedIndex = cmbDisplay.SelectedIndex
        My.Settings.cmbView = cmbView.SelectedIndex
        My.Settings.Save()
    End Sub

#End Region

    Private Sub screenDetect()
        'デバイス名が表示されるようにする
        Me.cmbDisplay.DisplayMember = "DeviceName"
        Me.cmbDisplay.DataSource = Screen.AllScreens

    End Sub
#End Region

#Region "ページの移動操作"

    Private Sub btnFirst_Click(sender As Object, e As EventArgs) Handles btnFirst.Click
        frmView.AxAcroPDF1.gotoFirstPage()
    End Sub

    Private Sub btnNext_Click(sender As Object, e As EventArgs) Handles btnNext.Click
        'todo:次のページがないとき
        frmView.AxAcroPDF1.gotoNextPage()
    End Sub

    Private Sub btnBack_Click(sender As Object, e As EventArgs) Handles btnBack.Click
        'todo:前のページがないとき
        frmView.AxAcroPDF1.gotoPreviousPage()
    End Sub

    Private Sub btnLast_Click(sender As Object, e As EventArgs) Handles btnLast.Click
        frmView.AxAcroPDF1.gotoLastPage()
    End Sub

#End Region

#Region "ファイルを開く"
    Private Sub btnFileOpen_Click(sender As Object, e As EventArgs) Handles btnFileOpen.Click
        Dim ret = OpenFileDialog1.ShowDialog()
        If ret = Windows.Forms.DialogResult.Cancel Then
            Exit Sub
        End If
        'todo : pdfではなかったときの処理
        txtFileName.Text = OpenFileDialog1.FileName

    End Sub

    Private Sub txtFileName_TextChanged(sender As Object, e As EventArgs) Handles txtFileName.TextChanged
        If txtFileName.Text = String.Empty Then
            Exit Sub
        End If
        frmView.AxAcroPDF1.LoadFile(txtFileName.Text)
    End Sub

#End Region
#Region "フォームをセカンドディスプレイに表示"
    Private Sub ComboBox1_SelectedIndexChanged(sender As Object, e As EventArgs) Handles cmbDisplay.SelectedIndexChanged
        If cmbDisplay.SelectedIndex < 0 Then
            Exit Sub
        End If
        If cmbDisplay.SelectedItem Is Nothing Then
            Exit Sub
        End If
        'フォームを表示するディスプレイのScreenを取得する
        Dim s As Screen = DirectCast(Me.cmbDisplay.SelectedItem, Screen)
        'フォームの開始位置をディスプレイの左上座標に設定する
        frmView.StartPosition = FormStartPosition.Manual
        frmView.Location = s.Bounds.Location
        frmView.Size = s.Bounds.Size

    End Sub



    Private Sub cmbView_SelectedIndexChanged(sender As Object, e As EventArgs) Handles cmbView.SelectedIndexChanged
        frmView.AxAcroPDF1.setView(cmbView.Text)
    End Sub

    Private Sub frmOperation_FormClosed(sender As Object, e As FormClosedEventArgs) Handles MyBase.FormClosed
        AppSettingSave()
        frmView.Close()
    End Sub


#End Region


End Class