﻿Imports PdfiumViewer
Public Class frmPdfViewer

    Dim pdfDoc As PdfDocument
    Dim page As Integer = 0
    Public Sub OpenFile(fileName As String)

        pdfDoc = PdfDocument.Load(fileName)
        FirstPage()
    End Sub

    Public Sub FirstPage()
        page = 0
        DisplayPage()
    End Sub

    Public Sub NextPage()
        If page < pdfDoc.PageCount Then
            page += 1
            DisplayPage()
        End If
    End Sub

    Public Sub PrePage()
        If 0 < page Then
            page -= 1
            DisplayPage()
        End If
    End Sub

    Private Sub DisplayPage()

        If (page >= pdfDoc.PageCount) Then
            Return
        End If
        Dim size = pdfDoc.PageSizes(page)
        Dim h1 = size.Width / size.Height ' // pdfの縦横比
        Dim h2 = PictureBox1.Width / PictureBox1.Height '  // コントロールの縦横比
        If (h2 > 10) Then ' 落ちないように Then
            Return
        End If
        Dim Width = 0, Height = 0
        If (h1 < h2) Then
            ' フォーム内にImageを当てはめる判定                    {
            Width = PictureBox1.Height * h1
            Height = PictureBox1.Height
        Else

            Width = PictureBox1.Width
            Height = PictureBox1.Width / h1
        End If
        Dim img = pdfDoc.Render(page, Width, Height, 96, 96, False) '  // 解像度は意味ない？
        Dim oldImage = PictureBox1.Image
        PictureBox1.Image = img
        If oldImage IsNot Nothing Then
            oldImage.Dispose() ';  // メモリー節約
        End If
    End Sub

End Class