﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace WpfApp1
{
    /// <summary>
    /// MainWindow.xaml の相互作用ロジック
    /// </summary>
    public partial class MainWindow : Window
    {
        private Window1 win1;
        public MainWindow()
        {
            InitializeComponent();
            win1 = new Window1();
            win1.Show();
            screenDetect();
        }

        private void screenDetect()
        {
            
            cmbDisplay.ItemsSource  = System.Windows.Forms.Screen.AllScreens;
            cmbDisplay.DisplayMemberPath = "DeviceName";
        }


        private void Button_Click(object sender, RoutedEventArgs e)
        {
            var openFileDialog1 = new Microsoft.Win32.OpenFileDialog();
            bool? ret = openFileDialog1.ShowDialog();
            if (ret != true)
            {
                return;
            }
            win1.MediaElement1.Source = new Uri(openFileDialog1.FileName);
            win1.MediaElement1.Play();


        }

        private void cmbDisplay_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            if (this.cmbDisplay.SelectedIndex < 0) {
                return;
            }
            if(this.cmbDisplay.SelectedValue == null)
            {
                return;
            }

            System.Windows.Forms.Screen s = (System.Windows.Forms.Screen)cmbDisplay.SelectedItem;
            
            win1.Top = s.Bounds.X;
            win1.Left = s.Bounds.Y;
            win1.Height = s.Bounds.Height;
            win1.Width = s.Bounds.Width;
        }
    }
}
