﻿Imports Microsoft.VisualStudio.TestTools.UnitTesting

Imports doubutu.UI.Form



'''<summary>
'''MoveTest のテスト クラスです。すべての
'''MoveTest 単体テストをここに含めます
'''</summary>
<TestClass()> _
Public Class MoveTest


    Private testContextInstance As TestContext

    '''<summary>
    '''現在のテストの実行についての情報および機能を
    '''提供するテスト コンテキストを取得または設定します。
    '''</summary>
    Public Property TestContext() As TestContext
        Get
            Return testContextInstance
        End Get
        Set(value As TestContext)
            testContextInstance = Value
        End Set
    End Property

#Region "追加のテスト属性"
    '
    'テストを作成するときに、次の追加属性を使用することができます:
    '
    'クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
    '<ClassInitialize()>  _
    'Public Shared Sub MyClassInitialize(ByVal testContext As TestContext)
    'End Sub
    '
    'クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
    '<ClassCleanup()>  _
    'Public Shared Sub MyClassCleanup()
    'End Sub
    '
    '各テストを実行する前にコードを実行するには、TestInitialize を使用
    '<TestInitialize()>  _
    'Public Sub MyTestInitialize()
    'End Sub
    '
    '各テストを実行した後にコードを実行するには、TestCleanup を使用
    '<TestCleanup()>  _
    'Public Sub MyTestCleanup()
    'End Sub
    '
#End Region


    '''<summary>
    '''CanChange のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub CanChangeTest()
        Dim target1 As Move = New Move(1, 2, 1, 1, Koma.SenteHI)
        Assert.AreEqual(Koma.SenteNI, target1.Koma)
        Dim target2 As Move = New Move(1, 3, 1, 4, Koma.GoteHI)
        Assert.AreEqual(Koma.GoteNI, target2.Koma)
    End Sub

    '''<summary>
    '''ToString のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub ToStringTest()
        Assert.AreEqual("-B1A2LI", (New Move(2, 1, 1, 2, Koma.GoteLI)).ToString)
    End Sub

    '''<summary>
    '''Move コンストラクター のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub MoveConstructorTest()
        Dim target As Move = New Move("-B1A2LI")
        Assert.AreEqual(2, target.FromPos.X)
        Assert.AreEqual(1, target.FromPos.Y)
        Assert.AreEqual(1, target.ToPos.X)
        Assert.AreEqual(2, target.ToPos.Y)
        Assert.AreEqual(Koma.GoteLI, target.Koma)

    End Sub
End Class
