﻿Public Class frmCondtion

  Private Sub FormValidate()

        If chk10min.Checked AndAlso
          txt10minSaveDirectory.Text = String.Empty Then
            Throw New InvalidException("保存先を選択してください。", txt10minSaveDirectory)
        End If

        If chk3min.Checked AndAlso
            txt3minSaveDirectory.Text = String.Empty Then
            Throw New InvalidException("保存先を選択してください。", txt3minSaveDirectory)
        End If

        If chk10sec.Checked AndAlso
            txt10secSaveDirectory.Text = String.Empty Then
            Throw New InvalidException("保存先を選択してください。", txt10secSaveDirectory)
        End If

        If chkAnimal.Checked AndAlso
            txtAnimalSaveDirectory.Text = String.Empty Then
            Throw New InvalidException("保存先を選択してください。", txtAnimalSaveDirectory)
        End If

        If txtName1.Text = String.Empty AndAlso
            txtName2.Text = String.Empty Then
            Throw New InvalidException("対局者をどちらか入力してください。", New Control() {txtName1, txtName2})
        End If

        If Not chk10min.Checked AndAlso
            Not chk3min.Checked AndAlso
            Not chk10sec.Checked AndAlso
            Not chkAnimal.Checked Then
            Throw New InvalidException("対局モードを選択してください。",
                                          New Control() {chk10min,
                                                         chk3min,
                                                         chk10sec,
                                                         chkAnimal})
        End If

    End Sub

    Private Sub btnDownload_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDownload.Click

        Try
            FormValidateUtil.FormClear(Me)
            FormValidate()
        Catch ex As InvalidException
            FormValidateUtil.MessageShow(ex)
            Exit Sub
        End Try

        Dim frm As New frmProgress
        Dim downloder As New downloder(
            frm.BackgroundWorker1,
            txtName1.Text,
            txtName2.Text)
        SetGTypeDirectoryPairTo(downloder)
        frm.downloder = downloder
        frm.ShowDialog()

    End Sub


    Private Sub SetGTypeDirectoryPairTo(ByVal downloder As downloder)
        Const GANIMAL As Integer = 2
        Const G10MIN As Integer = 0
        Const G10SEC As Integer = 3
        Const G3MIN As Integer = 1
        Dim gdLists As New List(Of gTypeDirectoryPair)
        If chkAnimal.Checked Then
            downloder.AddGtypeDirectoryPair(GANIMAL, txtAnimalSaveDirectory.Text)
        End If
        If chk10min.Checked Then
            downloder.AddGtypeDirectoryPair(G10MIN, txt10minSaveDirectory.Text)
        End If
        If chk10sec.Checked Then
            downloder.AddGtypeDirectoryPair(G10SEC, txt10secSaveDirectory.Text)
        End If
        If chk3min.Checked Then
            downloder.AddGtypeDirectoryPair(G3MIN, txt3minSaveDirectory.Text)
        End If
    End Sub

    Private Sub frmCondtion_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        SettingLoad()
    End Sub

    Private Sub btn10minSelectDirectory_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn10minSelectDirectory.Click
        FolderBrowserDialog1.SelectedPath = txt10minSaveDirectory.Text
        If FolderBrowserDialog1.ShowDialog() = Windows.Forms.DialogResult.OK Then
            txt10minSaveDirectory.Text = FolderBrowserDialog1.SelectedPath
        End If
    End Sub

    Private Sub btnAnimalSelectDirectory_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnAnimalSelectDirectory.Click
        FolderBrowserDialog1.SelectedPath = txtAnimalSaveDirectory.Text
        If FolderBrowserDialog1.ShowDialog() = Windows.Forms.DialogResult.OK Then
            txtAnimalSaveDirectory.Text = FolderBrowserDialog1.SelectedPath
        End If
    End Sub

    Private Sub btn10secSelectDirectory_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn10secSelectDirectory.Click
        FolderBrowserDialog1.SelectedPath = txt10secSaveDirectory.Text
        If FolderBrowserDialog1.ShowDialog() = Windows.Forms.DialogResult.OK Then
            txt10secSaveDirectory.Text = FolderBrowserDialog1.SelectedPath
        End If
    End Sub

    Private Sub btn3minSelectDirectory_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btn3minSelectDirectory.Click
        FolderBrowserDialog1.SelectedPath = txt3minSaveDirectory.Text
        If FolderBrowserDialog1.ShowDialog() = Windows.Forms.DialogResult.OK Then
            txt3minSaveDirectory.Text = FolderBrowserDialog1.SelectedPath
        End If
    End Sub

    Private Sub frmCondtion_FormClosed(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed
        SettingSave()
    End Sub

    Private Sub SettingLoad()
        With My.Settings
            .Reload()
            txtName1.Text = .Name1
            txtName2.Text = .Name2
            txt10minSaveDirectory.Text = .pathOf10min
            txt10secSaveDirectory.Text = .pathOf10sec
            txt3minSaveDirectory.Text = .pathOf3min
            txtAnimalSaveDirectory.Text = .pathOfAnimal
            chk10min.Checked = .chk10min
            chk3min.Checked = .chk3min
            chk10min.Checked = .chk10min
            chkAnimal.Checked = .chkAnimal
        End With
    End Sub

    Private Sub SettingSave()
        With My.Settings
            .Name1 = txtName1.Text
            .Name2 = txtName2.Text
            .pathOf10min = txt10minSaveDirectory.Text
            .pathOf10sec = txt10secSaveDirectory.Text
            .pathOf3min = txt3minSaveDirectory.Text
            .pathOfAnimal = txtAnimalSaveDirectory.Text
            .chk10min = chk10min.Checked
            .chk3min = chk3min.Checked
            .chk10min = chk10min.Checked
            .chkAnimal = chkAnimal.Checked
            .Save()
        End With
    End Sub


End Class
