﻿Public Class downloder

    Public Property backGroudWoker As System.ComponentModel.BackgroundWorker
    Private baseUrl As String = "http://swks.sakura.ne.jp/wars/kifusearch/"
    Private csrfmiddlewaretoken As String
    Dim cc As System.Net.CookieContainer

    Private _gTypePairList As New List(Of gTypeDirectoryPair)
    Private _gTypePairListIndex As Integer

    Public Property name1 As String
    Public Property name2 As String



    Public ReadOnly Property DownLoadIndex As Integer
        Get
            Dim idx As Integer = 0
            For i As Integer = 0 To _gTypePairListIndex
                idx += _gTypePairList(i).DownloadIndexOfList
            Next
            Return idx
        End Get
    End Property

    Public ReadOnly Property DownLoadsCount As Integer
        Get
            Dim count As Integer = 0
            For Each p As gTypeDirectoryPair In _gTypePairList
                count += p.List.Count
            Next
            Return count
        End Get
    End Property

    Public Property IsDownloading As Boolean = False
    Public Property IsComplete As Boolean = False

    Private Sub New()
    End Sub
    Public Sub New(ByVal bg As System.ComponentModel.BackgroundWorker, ByVal name1 As String, ByVal name2 As String)
        _backGroudWoker = bg
        _name1 = name1
        _name2 = name2
    End Sub

    Private Sub AddGtypeDirectoryPair(ByVal pair As gTypeDirectoryPair)
        _gTypePairList.Add(pair)
    End Sub

    Public Sub AddGtypeDirectoryPair(ByVal gtype As Integer, ByVal saveDirectory As String)
        AddGtypeDirectoryPair(New gTypeDirectoryPair(gtype, saveDirectory))
    End Sub

    Public Sub Start()
        _backGroudWoker.ReportProgress(0, "ログイン開始")
        LoginReq()
        _backGroudWoker.ReportProgress(0, "一覧取得中")
        For Each p As gTypeDirectoryPair In _gTypePairList
            ListPageReadReq(p)
        Next

        _backGroudWoker.ReportProgress(0, "ダウンロード開始")
        For i As Integer = 0 To _gTypePairList.Count - 1
            _gTypePairListIndex = i
            DownLoadsReq(_gTypePairList(Me._gTypePairListIndex))
        Next
        IsComplete = True
        _backGroudWoker.ReportProgress(100, "ダウンロード終了")
    End Sub

    Private Sub LoginReq()

        cc = New System.Net.CookieContainer()

        Dim webreq As System.Net.HttpWebRequest = DirectCast(
             System.Net.WebRequest.Create(baseUrl), System.Net.HttpWebRequest)
        webreq.CookieContainer = cc
        Dim webres As System.Net.WebResponse = webreq.GetResponse()
        Dim st As System.IO.Stream = webres.GetResponseStream()

        Dim sr As New System.IO.StreamReader(st, System.Text.Encoding.UTF8)

        Dim htmlSource As String = sr.ReadToEnd()

        sr.Close()
        st.Close()
        webres.Close()

        csrfmiddlewaretoken = GetCsrmiddlewaretoken(htmlSource)
        csrfmiddlewaretoken = csrfmiddlewaretoken.Substring(1, csrfmiddlewaretoken.Length - 2)

    End Sub

    Private Sub DownLoadsReq(ByVal p As gTypeDirectoryPair)

        Dim wc As New System.Net.WebClient()

        Dim dirfullpath As String = p.saveDirectoryPathName
        If Not IOUtil.CreateDirectoryIfNotExist(dirfullpath) Then
            _backGroudWoker.ReportProgress(0, String.Format("ディレクトリ""{0}""が作成できません", dirfullpath))
            Exit Sub
        End If

        IsDownloading = True
        For Each link As aLink In p.List
            If backGroudWoker.CancellationPending Then
                Throw New CancelException
            End If
            _backGroudWoker.ReportProgress(DownLoadIndex \ DownLoadsCount, String.Format("{0}", link.Text))
            DownLoadOneLink(wc, link, dirfullpath)
            p.DownloadIndexOfList += 1
        Next

        wc.Dispose()
    End Sub

    Private Sub DownLoadOneLink(ByVal wc As System.Net.WebClient, ByVal link As aLink, ByVal dirfullpath As String)
        Dim url As String = link.Url
        Dim filename As String = System.IO.Path.GetFileName(url)
        Dim fullpath As String = dirfullpath & "/" & filename
        Try
            wc.DownloadFile(url, fullpath)
        Catch ex As Exception
            '  Log.Err(url & ex.ToString)
        End Try
    End Sub

    Private Function GetCsrmiddlewaretoken(ByVal text As String) As String
        Dim m As System.Text.RegularExpressions.Match =
            System.Text.RegularExpressions.Regex.Match(
            text,
               "\<input\s+[^>]*name\s*=\s*'csrfmiddlewaretoken'\s*value=(?<value>'.*') /\>",
          System.Text.RegularExpressions.RegexOptions.IgnoreCase Or _
          System.Text.RegularExpressions.RegexOptions.Singleline)

        Return m.Groups("value").Value.Trim()
    End Function



    Private Sub ListPageReadReq(ByVal p As gTypeDirectoryPair)

        Dim dirfullpath As String = p.saveDirectoryPathName
        If Not IOUtil.CreateDirectoryIfNotExist(dirfullpath) Then
            _backGroudWoker.ReportProgress(0, String.Format("ディレクトリ""{0}""が作成できません", dirfullpath))
            Exit Sub
        End If
        Dim ps As New Hashtable
        ps.Add("csrfmiddlewaretoken", csrfmiddlewaretoken)
        ps.Add("name1", _name1)
        ps.Add("name2", _name2)
        ps.Add("gtype", p.gType)

        Dim encoder As System.Text.Encoding = System.Text.Encoding.UTF8

        Dim resText As String = HttpPostUtl.HttpPost(baseUrl, ps, cc, encoder)
        p.DownloadIndexOfList = 0
        Dim allList As IList(Of aLink) = GetLinks(resText)
        Dim existsList As IList(Of String) = IOUtil.GetFileNames(p.saveDirectoryPathName)
        p.List = GetRemovedList(allList, existsList)

    End Sub

    Private Function GetRemovedList(ByVal source As IList(Of aLink), ByVal target As IList(Of String)) As IList(Of aLink)
        Dim newList As New List(Of aLink)
        For Each s As aLink In source
            If Not target.Contains(s.Text) Then
                newList.Add(s)
            End If
        Next
        Return newList
    End Function


    Private Function GetLinks(ByVal text As String) As IList(Of aLink)

        Dim mc As System.Text.RegularExpressions.MatchCollection =
                   System.Text.RegularExpressions.Regex.Matches(
                    text, _
               "<a\s+class=""btn1""\s+href=""(?<url>[^""]+\.kif)"">保存</a>",
          System.Text.RegularExpressions.RegexOptions.IgnoreCase Or _
          System.Text.RegularExpressions.RegexOptions.Singleline)

        Dim links As New List(Of aLink)
        For Each m As System.Text.RegularExpressions.Match In mc
            Dim link As New aLink
            link.Url = baseUrl + m.Groups("url").Value
            link.Text = System.IO.Path.GetFileName(link.Url)
            links.Insert(0, link)
        Next
        Return links
    End Function


End Class
