﻿Public Class IOUtil
    ''' <summary>
    ''' ディレクトリを作成する。
    ''' </summary>
    ''' <param name="path"></param>
    ''' <returns>作成に成功したらTure 失敗したらFlase</returns>
    ''' <remarks></remarks>
    Public Shared Function CreateDirectoryIfNotExist(ByVal path As String) As Boolean
        If Not System.IO.File.Exists(path) Then
            Try
                System.IO.Directory.CreateDirectory(path)
            Catch ex As Exception
                '  Log.Err("Can Not Create Directory:" & path)
                Return False
            End Try
        End If
        Return True
    End Function

    ''' <summary>
    ''' フォルダの中にあるファイル名の一覧を返す。
    ''' </summary>
    ''' <param name="directoryPath"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetFileNames(ByVal directoryPath As String) As IList(Of String)
        Dim fileFullPathNames As String() = System.IO.Directory.GetFiles(
                directoryPath, "*", System.IO.SearchOption.TopDirectoryOnly)
        Dim fileNames As New List(Of String)
        For Each path As String In fileFullPathNames
            fileNames.Add(IO.Path.GetFileName(path))
        Next
        Return fileNames
    End Function
End Class
