﻿Public Class FormValidateUtil

    Public Shared Property ErrorColor As Color = Color.Red
    Public Shared Property NormalColor As Color = Color.White

    Public Shared Sub FormClear(ByVal form As Form)
        For Each c As Control In form.Controls
            If c.BackColor = ErrorColor Then
                c.BackColor = NormalColor
            End If
        Next
    End Sub

    Public Shared Sub MessageShow(ByVal inputError As InvalidException)

        For Each c As Control In inputError.Controls
            If Not c.BackColor = ErrorColor Then
                NormalColor = c.BackColor
            End If
            c.BackColor = ErrorColor
        Next
        MessageBox.Show(inputError.DisplayMessage, "入力エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning)
        If 1 <= inputError.Controls.Length Then
            inputError.Controls(0).Focus()
        End If

    End Sub

End Class
