﻿Namespace Book
    Public Class CoordinatesTransFormer

        Private _rotate As Integer
        Private _isMirror As Boolean

        Sub New(ByVal first As Point)
            _rotate = 0
            _isMirror = False

            If first = New Point("d3") Then
                _rotate = 1
                _isMirror = True
            ElseIf first = New Point("c4") Then
                _rotate = 2
            ElseIf first = New Point("e6") Then
                _rotate = 3
                _isMirror = True
            End If
        End Sub

        ''' <summary>
        ''' 座標をf5を開始点とする座標系に正規化する
        ''' </summary>
        ''' <param name="p"></param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Function Normalize(ByVal p As Point) As Point
            Dim newp As Point = RotatePoint(p, _rotate)
            If _isMirror Then
                newp = MirrorPoint(newp)
            End If
            Return newp
        End Function

        ''' <summary>
        ''' f5を開始点とする座標系を本来の座標に戻す。
        ''' </summary>
        ''' <param name="p"></param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Public Function DeNormalize(ByVal p As Point) As Point
            Dim newp As Point
            If _isMirror Then
                newp = MirrorPoint(p)
            Else
                newp = New Point(p.X, p.Y)
            End If
            Return RotatePoint(newp, -_rotate)
        End Function

        ''' <summary>
        ''' 座標回転
        ''' </summary>
        ''' <param name="oldPoint"></param>
        ''' <param name="rotate">0:0度、1:90度,2:180度,3:270度</param>
        ''' <returns></returns>
        ''' <remarks></remarks>
        Shared Function RotatePoint(ByVal oldPoint As Point, ByVal rotate As Integer) As Point
            rotate = rotate Mod 4
            If rotate < 0 Then
                rotate += 4
            End If
            Dim x As Integer
            Dim y As Integer
            Select Case rotate
                Case 1
                    x = oldPoint.Y
                    y = Board.SIZE_X - oldPoint.X + 1
                Case 2
                    x = Board.SIZE_X - oldPoint.X + 1
                    y = Board.SIZE_Y - oldPoint.Y + 1
                Case 3
                    x = Board.SIZE_X - oldPoint.Y + 1
                    y = oldPoint.X
                Case Else 'case 0
                    x = oldPoint.X
                    y = oldPoint.Y
            End Select
            Return New Point(x, y)
        End Function

        Shared Function MirrorPoint(ByVal oldPoint As Point) As Point
            Return New Point(Board.SIZE_X - oldPoint.X + 1, oldPoint.Y)
        End Function

    End Class

End Namespace
