﻿Namespace AI.Level3

    Public Class alphabetaAI
        Implements AI.computerAI

        Private _presearch_depth As Integer = 3
        Private _normal_depth As Integer = 5
        Private _wld_depth As Integer = 13
        Private _perfect_depth As Integer = 11

        Private eval As Evaluator

        Public Sub Initialize(ByVal nowBoard As Board) Implements computerAI.Initialize
        End Sub

        Public Function EvaluationValue(ByVal targetBoard As Board) As Integer Implements computerAI.EvaluationValue
            Dim tempBoard As AIBoard = New AIBoard(targetBoard)
            Dim limit As Integer
            eval = New MidEvaluator
            If Board.MAX_TURNS - targetBoard.GetTurns <= _wld_depth Then
                limit = Integer.MaxValue
                If Board.MAX_TURNS - targetBoard.GetTurns <= _perfect_depth Then
                    eval = New PerfectEvaluator
                Else
                    eval = New WLDEvaluator
                End If
            Else
                limit = _normal_depth
            End If

            Return -negaMax(tempBoard, limit - 1, -Integer.MaxValue, Integer.MaxValue)
        End Function

        Function negaMax(ByVal targetBoard As AIBoard, ByVal depth As Integer, ByVal alpha As Integer, ByVal beta As Integer) As Integer
            If depth <= 0 OrElse targetBoard.IsGameEnd Then
                Return eval.Evaluate(targetBoard)
            End If

            Dim val As Integer
            Dim postions As IList(Of Point) = targetBoard.MovablePostions

            If postions.Count = 0 Then
                targetBoard.Pass()
                val = -negaMax(targetBoard, depth, -beta, -alpha)
                targetBoard.Undo()
                Return val
            End If

            For Each discPoint As Point In postions

                targetBoard.Move(discPoint)
                val = -negaMax(targetBoard, depth - 1, -beta, -alpha)
                targetBoard.Undo()
                alpha = Math.Max(alpha, val)
                If alpha >= beta Then
                    Return alpha
                End If
            Next

            Return alpha
        End Function






    End Class
End Namespace
