/* グラフィック処理関係 */
#include "bootpack.h"

void init_mouse_cursor8(char *mouse, char backcolor)
/*マウスカーソルを準備(16x16*/
{
	static char cursor[16][16] = {
		"**************..",
		"*ooooooooooo*...",
		"*oooooooooo*....",
		"*ooooooooo*.....",
		"*oooooooo*......",
		"*ooooooo*.......",
		"*ooooooo*.......",
		"*oooooooo*......",
		"*oooo**ooo*.....",
		"*ooo*..*ooo*....",
		"*oo*....*ooo*...",
		"*o*......*ooo*..",
		"**........*ooo*.",
		"*..........*ooo*",
		"............*oo*",
		"............,***"
	};
	int x, y;
	
	for (y = 0; y < 16; y++){
		for (x = 0; x < 16; x++){
			if (cursor[y][x] == '*'){
				mouse[y * 16 + x] = COL8_BLACK;
			}
			if (cursor[y][x] == 'o'){
				mouse[y * 16 + x] = COL8_WHITE;
			}
			if (cursor[y][x] == '.'){
				mouse[y * 16 + x] = backcolor;
			}
		}
	}
	return;
}
void putblock8_8(char *vram, int vxsize, int pxsize, int pysize, int px0, int py0, char *buf, int bxsize)
{
	int x, y;
	for (y = 0; y < pysize; y++){
		for (x = 0; x < pxsize; x++){
			vram[(py0 + y) * vxsize + (px0 + x)] = buf[y * bxsize + x];
		}
	}
	return;
}
void putfonts8_asc(char *vram, int xsize, int x, int y, char color, unsigned char *str)
{
	extern char hankaku[4096];
	for(;*str != '\0'; str++){
		putfont8(vram, xsize, x, y, color, hankaku + *str * 16);
		x += 8;
	}
	return;
}
void putfont8(char *vram, int xsize, int x, int y, char color, char *font)
{
	int i;
	char d; /*data*/
	char *p;
	for (i = 0; i < 16; i++){
		d = font[i];
		p = vram + (y + i) * xsize + x;
		if ((d & 0x80) != 0) { p[0] = color;}
		if ((d & 0x40) != 0) { p[1] = color;}
		if ((d & 0x20) != 0) { p[2] = color;}
		if ((d & 0x10) != 0) { p[3] = color;}
		if ((d & 0x08) != 0) { p[4] = color;}
		if ((d & 0x04) != 0) { p[5] = color;}
		if ((d & 0x02) != 0) { p[6] = color;}
		if ((d & 0x01) != 0) { p[7] = color;}
	}
	return;
}
void init_screen(char *vram, int xsize, int ysize)
{
	boxfill8(vram, xsize, COL8_DARK_PALEBLUE, 0, 0, xsize - 1, ysize - 29);
	boxfill8(vram, xsize, COL8_LIGHT_GRAY, 0, ysize - 28, xsize - 1, ysize - 28);
	boxfill8(vram, xsize, COL8_WHITE, 0, ysize - 27, xsize - 1, ysize - 27);
	boxfill8(vram, xsize, COL8_LIGHT_GRAY, 0, ysize - 26, xsize - 1, ysize - 1);
	
	boxfill8(vram, xsize, COL8_WHITE, 3, ysize - 24, 59, ysize -24);
	boxfill8(vram, xsize, COL8_WHITE, 2, ysize - 24, 2, ysize - 4);
	boxfill8(vram, xsize, COL8_DARK_GRAY, 3, ysize - 4, 59, ysize -4);
	boxfill8(vram, xsize, COL8_DARK_GRAY, 59, ysize - 23, 59, ysize - 5);
	boxfill8(vram, xsize, COL8_BLACK, 2, ysize - 3, 59, ysize - 3);
	boxfill8(vram, xsize, COL8_BLACK, 60, ysize - 24, 60, ysize - 3);
	
	boxfill8(vram, xsize, COL8_DARK_GRAY, xsize - 47, ysize - 24, xsize - 4, ysize - 24);
	boxfill8(vram, xsize, COL8_DARK_GRAY, xsize - 47, ysize - 23, xsize - 47, ysize - 4);
	boxfill8(vram, xsize, COL8_WHITE, xsize - 47, ysize - 3, xsize - 4, ysize - 3);
	boxfill8(vram, xsize, COL8_WHITE, xsize - 3, ysize - 24, xsize - 3, ysize - 3);
}

void boxfill8(unsigned char *vram, int xsize, unsigned char c, int x0, int y0, int x1, int y1)
{
	int x, y;
	for (y = y0; y <= y1; y++){
		for (x = x0; x <= x1; x++){
			vram[y * xsize + x] = c;
		}
	}
	return;
}

void init_palette(void)
{
	static unsigned char table_rgb[16 * 3] = {
		0x00, 0x00, 0x00, /*0:黒*/
		0xff, 0x00, 0x00, /*1:明るい赤 */
		0x00, 0xff, 0x00, /*2:明るい緑*/
		0xff, 0xff, 0x00, /*3:明るい黄色*/
		0x00, 0x00, 0xff, /*4:明るい青*/
		0xff, 0x00, 0xff, /*5:明るい紫*/
		0x00, 0xff, 0xff, /*6:明るい水色*/
		0xff, 0xff, 0xff, /*7:白*/
		0xc6, 0xc6, 0xc6, /*8:明るい灰色*/
		0x84, 0x00, 0x00, /*9:暗い赤*/
		0x00, 0x84, 0x00, /*10:暗い緑*/
		0x84, 0x84, 0x00, /*11:暗い黄色*/
		0x00, 0x00, 0x84, /*12:暗い青*/
		0x84, 0x00, 0x84, /*13:暗い紫*/
		0x00, 0x84, 0x84, /*14:暗い水色*/
		0x84, 0x84, 0x84, /*15:暗い灰色*/
	};
	set_palette(0, 15, table_rgb);
	return;
}

void set_palette(int start, int end, unsigned char *rgb)
{
	int i, eflags;
	eflags = io_load_eflags(); //割り込み許可フラグの値を記録する。
	io_cli(); //許可フラグを0にして割り込み禁止にする
	io_out8(0x3c8, start);
	for (i = start; i <= end; i++){
		io_out8(0x3c9, rgb[0] / 4);
		io_out8(0x3c9, rgb[1] / 4);
		io_out8(0x3c9, rgb[2] / 4);
		rgb += 3;
	}
	io_store_eflags(eflags); //割り込み許可フラグを元に戻す。
	return;
}