#region Copyright

/*
 * Copyright 2005-2008 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

#endregion

using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using S2FormExample.Logics.Dto;

namespace S2FormExample.Logics.Dao.Impl
{
    /// <summary>
    /// CSVo͗pDAONX
    /// </summary>
    public class OutputCSVDaoImpl : IOutputCSVDao
    {
        /// <summary>
        /// RXgN^
        /// </summary>
        public OutputCSVDaoImpl()
        {
            ;
        }

        #region IOutputCSVDao Members

        /// <summary>
        /// Јf[^o͂
        /// </summary>
        /// <param name="path">o͐pX</param>
        /// <param name="list">Јf[^</param>
        /// <returns>o͌</returns>
        public int OutputEmployeeList(string path, IList<EmployeeCsvDto> list)
        {
            if (String.IsNullOrEmpty(path))
                throw new ArgumentNullException("path");
            if (list == null)
                throw new ArgumentNullException("list");

            int ret = 0;
            using (FileStream fs = File.Open(path, FileMode.Create))
            {
                StreamWriter writer = new StreamWriter(fs, Encoding.GetEncoding(932));
                StringBuilder builder;
                try
                {
                    foreach (EmployeeCsvDto dto in list)
                    {
                        builder = new StringBuilder();

                        builder.Append(String.Format("\"{0}\",", dto.Code));
                        builder.Append(String.Format("\"{0}\",", dto.Name));
                        builder.Append(String.Format("{0},", dto.Gender));
                        builder.Append(String.Format("\"{0}\",", dto.GenderName));
                        if (dto.EntryDay.HasValue)
                            builder.Append(String.Format("\"{0:yyyy/M/d}\",", dto.EntryDay.Value));
                        else
                            builder.Append("\"\",");
                        builder.Append(String.Format("\"{0}\",", dto.DeptCode));
                        builder.Append(String.Format("\"{0}\"", dto.DeptName));

                        writer.WriteLine(builder.ToString());
                        ret++;
                    }
                    writer.Close();
                }
                catch (Exception ex)
                {
                    writer.Close();
                    throw ex;
                }
            }

            return ret;
        }

        #endregion
    }
}