#region Copyright

/*
 * Copyright 2005-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

#endregion

using System.Collections.Generic;
using Seasar.Dao.Attrs;
using Seasar.Quill.Attrs;
using S2FormExample.Logics.Dto;

namespace S2FormExample.Logics.Dao
{
    /// <summary>
    /// ЈpDAO
    /// </summary>
    [S2Dao]
    [Implementation]
    [Bean(typeof(EmployeeDto))]
    public interface IEmployeeDao
    {
        /// <summary>
        /// Јꗗ擾
        /// </summary>
        /// <returns>Јꗗ</returns>
        [Query("order by t_emp.n_id")]
        IList<EmployeeDto> GetAll();

        /// <summary>
        /// Јf[^擾
        /// </summary>
        /// <param name="id">ЈID</param>
        /// <returns>Јf[^</returns>
        [Query("t_emp.n_id = /*id*/1")]
        EmployeeDto GetData(int id);

        /// <summary>
        /// ЈID擾
        /// </summary>
        /// <param name="code">ЈR[h</param>
        /// <returns>ЈID</returns>
        [Sql("select n_id from t_emp where s_code = /*code*/'000001'")]
        int GetId(string code);

        /// <summary>
        /// ʂŌ
        /// </summary>
        /// <param name="gender">ID</param>
        /// <returns>Јꗗ</returns>
        [Query("n_gender = /*gender*/1")]
        IList<EmployeeDto> FindByGender(int gender);

        /// <summary>
        /// Јf[^}
        /// </summary>
        /// <param name="data">}f[^</param>
        /// <returns>}</returns>
        [NoPersistentProps("Id")]
        int InsertData(EmployeeDto data);

        /// <summary>
        /// Јf[^XV
        /// </summary>
        /// <param name="data">XVf[^</param>
        /// <returns>XV</returns>
        int UpdateData(EmployeeDto data);

        /// <summary>
        /// Јf[^폜
        /// </summary>
        /// <param name="data">Јf[^</param>
        /// <returns>폜</returns>
        int DeleteData(EmployeeDto data);
    }
}