﻿#region Copyright
/*
 * Copyright 2005-2015 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
#endregion

using System.Collections;
using Seasar.Dao.Attrs;

namespace Seasar.Tests.Dao.Impl
{
    [Bean(typeof(Employee))]
    public interface IEmployeeDao
    {
        IList GetAllEmployees();

#if !NET_1_1
        System.Collections.Generic.IList<Employee> GetAllEmployeesToGenericList1();

        System.Collections.Generic.List<Employee> GetAllEmployeesToGenericList2();
#endif

        Employee[] GetAllEmployeeArray();

        [Query("empno=/*empno*/")]
        Employee GetEmployee(int empno);

        [SqlFile]
        int GetCount();

        [SqlFile("Seasar.Tests/Dao.Impl.SqlFile.GetCount.sql")]
        int GetCount2();

        void Update(Employee employee);

        void UpdateSqlFileEncodingDefault(Employee employee);

        void UpdateSqlFileEncodingUTF8(Employee employee);

        Employee[] GetEmployeesByDeptno(int deptno);
    }
}