﻿#region Copyright
/*
 * Copyright 2005-2013 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
#endregion

using Seasar.Unit.UI;

namespace Seasar.Examples
{
    /// <summary>
    /// Examples Explorerで表示する為のデモアプリ
    /// </summary>
    public interface IExamplesHandler
    {
        /// <summary>
        /// デモを実行します。
        /// </summary>
        void Main(ExamplesContext context);

        /// <summary>
        /// 当該デモアプリの設定ファイルを出力します。
        /// </summary>
        void AppendDicon(TextAppender appender);

        /// <summary>
        /// 当該デモアプリのソースコードを出力します。
        /// </summary>
        void AppendCode(TextAppender appender);

        string Title { get;        }
    }
}