﻿#region Copyright
/*
 * Copyright 2005-2013 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
#endregion

using System;
using Seasar.Framework.Container;
using Seasar.Framework.Container.Factory;

namespace Seasar.Dao.Examples.SqlAttr
{
    /// <summary>
    /// Sql属性のサンプルを実行します。
    /// </summary>
    public class FirebirdSqlAttrClient
    {
        private const string PATH = "Seasar.Dao.Examples/SqlAttr/FirebirdSqlAttr.dicon";

        public void Main()
        {
            IS2Container container = S2ContainerFactory.Create(PATH);
            IEmployeeDao employeeDao = (IEmployeeDao) container.GetComponent(typeof(IEmployeeDao));

            // 従業員名・部署番号から従業員番号を取得
            int empno = employeeDao.GetEmpnoByEnameDeptnum("SMITH", 20);
            Console.WriteLine("従業員名が[SMITH]で部署番号が[20]である従業員の従業員番号は["
                + empno + "]です");
        }
    }
}