DROP USER S2DOTNETDEMO CASCADE;

CREATE USER S2DOTNETDEMO PROFILE "DEFAULT" IDENTIFIED BY "s2dotnetdemo" DEFAULT TABLESPACE "USERS" TEMPORARY TABLESPACE "TEMP" ACCOUNT UNLOCK;
GRANT "CONNECT" TO "S2DOTNETDEMO";

GRANT UNLIMITED TABLESPACE TO "S2DOTNETDEMO";
GRANT CREATE TABLE TO "S2DOTNETDEMO";

CREATE TABLE S2DOTNETDEMO.DEPT (
	DEPTNO NUMBER(2, 0) NOT NULL,
	DNAME VARCHAR2(14) NULL,
	LOC VARCHAR2(13) NULL,
	VERSIONNO NUMBER(8, 0) NULL,
	ACTIVE NUMBER(1, 0) NULL,
	CONSTRAINT PK_DEPT PRIMARY KEY (DEPTNO)
);

CREATE TABLE S2DOTNETDEMO.DEPT2 (
	DEPTNO NUMBER(2, 0) NOT NULL,
	DNAME VARCHAR2(14) NULL,
	ACTIVE NUMBER(1, 0) NULL,
	CONSTRAINT PK_DEPT2 PRIMARY KEY (DEPTNO)
);

CREATE TABLE S2DOTNETDEMO.EMP (
	EMPNO NUMBER(4, 0) NOT NULL,
	ENAME VARCHAR2(10) NULL,
	JOB VARCHAR2(9) NULL,
	MGR NUMBER(4, 0) NULL,
	HIREDATE DATE NULL,
	SAL NUMBER(7, 2) NULL,
	COMM NUMBER(7, 2) NULL,
	DEPTNO NUMBER(2, 0) NULL,
	TSTAMP TIMESTAMP(7) NULL,
	CONSTRAINT PK_EMP PRIMARY KEY (EMPNO)
);

CREATE TABLE S2DOTNETDEMO.EMP2 (
	EMPNO NUMBER(4, 0) NOT NULL,
	ENAME VARCHAR2(10) NULL,
	DEPTNUM NUMBER(2, 0) NULL,
	CONSTRAINT PK_EMP2 PRIMARY KEY (EMPNO)
);

CREATE TABLE S2DOTNETDEMO.EMP_NULLABLE (
	EMPNO NUMBER(4, 0) NOT NULL,
	ENAME VARCHAR2(10) NULL,
	JOB VARCHAR2(9) NULL,
	MGR NUMBER(4, 0) NULL,
	HIREDATE DATE NULL,
	SAL NUMBER(7, 2) NULL,
	COMM NUMBER(7, 2) NULL,
	DEPTNO NUMBER(2, 0) NULL,
	TSTAMP TIMESTAMP(7) NULL,
	NULLABLE_NEXT_REST_DATE DATE NULL,
	CONSTRAINT PK_EMP_NULLABLE PRIMARY KEY (EMPNO)
);

CREATE TABLE S2DOTNETDEMO.GENERIC_NULLABLE (
	ID NUMBER(38, 0) NOT NULL,
	DDATE DATE NULL,
	ENTITYNO NUMBER(19, 0) NOT NULL,
	CONSTRAINT PK_GENERIC_NULLABLE PRIMARY KEY (ID)
);
CREATE SEQUENCE S2DOTNETDEMO.SEQ_GENERIC_NULLABLE;

CREATE TABLE S2DOTNETDEMO.UNDER_SCORE (
	UNDER_SCORE_NO NUMBER(4, 0) NOT NULL,
	TABLE_NAME VARCHAR2(50) NULL,
	TABLE_NAME_ VARCHAR2(50) NULL,
	"_TABLE_NAME" VARCHAR2(50) NULL,
	"_TABLE_NAME_" VARCHAR2(50) NULL,
	CONSTRAINT PK_UNDER_SCORE PRIMARY KEY (UNDER_SCORE_NO)
);

CREATE TABLE S2DOTNETDEMO.IDTABLE (
	ID NUMBER(18, 0) NOT NULL,
	ID_NAME VARCHAR2(20) NULL,
	CONSTRAINT PK_IDTABLE PRIMARY KEY (ID)
);
CREATE SEQUENCE S2DOTNETDEMO.SEQ_IDTABLE;

CREATE TABLE S2DOTNETDEMO.BASICTYPE (
	ID NUMBER (18, 0) NOT NULL,
	BOOLTYPE NUMBER (1, 0) NULL,
	BYTETYPE NUMBER (3, 0) NULL,
	SBYTETYPE NUMBER (3, 0) NULL,
	INT16TYPE NUMBER (5, 0) NULL,
	INT32TYPE NUMBER (10, 0) NULL,
	INT64TYPE NUMBER (19, 0) NULL,
	SINGLETYPE FLOAT NULL,
	DOUBLETYPE DOUBLE PRECISION NULL,
	DECIMALTYPE NUMBER (28, 0) NULL,
	STRINGTYPE VARCHAR2 (1024) NULL,
	DATETIMETYPE DATE NULL,
	CONSTRAINT PK_BASICTYPE PRIMARY KEY (ID)
);

CREATE TABLE S2DOTNETDEMO.DECIMAL_VERSION_NO (
	EMPNO NUMBER (4, 0) NOT NULL ,
	EMP_NAME VARCHAR2(60) NULL,
	VERSION_NO NUMBER (4, 0) NOT NULL,
	CONSTRAINT PK_DECIMAL_VERSION_NO PRIMARY KEY (EMPNO)
);

CREATE TABLE S2DOTNETDEMO.INT_VERSION_NO (
	EMPNO NUMBER (4, 0) NOT NULL ,
	EMP_NAME VARCHAR2(60) NULL,
	VERSION_NO NUMBER (4, 0) NOT NULL,
	CONSTRAINT PK_INT_VERSION_NO PRIMARY KEY (EMPNO)
);

CREATE TABLE S2DOTNETDEMO.EMP_DEFAULT (
	EMPNO NUMBER (4, 0) NOT NULL,
	ENAME VARCHAR2 (10) DEFAULT 'def_name' NOT NULL,
	JOB NUMBER (9) NULL,
	MGR NUMBER (4, 0) DEFAULT 99 NOT NULL,
	SAL DECIMAL (7, 2) DEFAULT 9.99 NOT NULL,
	COMM NUMBER (7, 2) NULL,
	DEPTNO NUMBER (2, 0) NULL,
	TSTAMP TIMESTAMP(7) NULL,
	VERSION NUMBER (4, 0) NULL,
	CONSTRAINT PK_EMP_DEFAULT PRIMARY KEY (EMPNO)
);

INSERT INTO S2DOTNETDEMO.EMP VALUES (7369, 'SMITH',  'CLERK',	  7902, TO_DATE('1980-12-17', 'YYYY-MM-DD'),  800, NULL, 20, TO_DATE('2000-01-01', 'YYYY-MM-DD'));
INSERT INTO S2DOTNETDEMO.EMP VALUES (7499, 'ALLEN',  'SALESMAN',  7698, TO_DATE('1981-02-20', 'YYYY-MM-DD'), 1600,	300, 30, TO_DATE('2000-01-01', 'YYYY-MM-DD'));
INSERT INTO S2DOTNETDEMO.EMP VALUES (7521, 'WARD',	 'SALESMAN',  7698, TO_DATE('1981-02-22', 'YYYY-MM-DD'), 1250,	500, 30, TO_DATE('2000-01-01', 'YYYY-MM-DD'));
INSERT INTO S2DOTNETDEMO.EMP VALUES (7566, 'JONES',  'MANAGER',   7839, TO_DATE('1981-04-02', 'YYYY-MM-DD'), 2975, NULL, 20, TO_DATE('2000-01-01', 'YYYY-MM-DD'));
INSERT INTO S2DOTNETDEMO.EMP VALUES (7654, 'MARTIN', 'SALESMAN',  7698, TO_DATE('1981-09-28', 'YYYY-MM-DD'), 1250, 1400, 30, TO_DATE('2000-01-01', 'YYYY-MM-DD'));
INSERT INTO S2DOTNETDEMO.EMP VALUES (7698, 'BLAKE',  'MANAGER',   7839, TO_DATE('1981-05-01', 'YYYY-MM-DD'), 2850, NULL, 30, TO_DATE('2000-01-01', 'YYYY-MM-DD'));
INSERT INTO S2DOTNETDEMO.EMP VALUES (7782, 'CLARK',  'MANAGER',   7839, TO_DATE('1981-06-09', 'YYYY-MM-DD'), 2450, NULL, 10, TO_DATE('2000-01-01', 'YYYY-MM-DD'));
INSERT INTO S2DOTNETDEMO.EMP VALUES (7788, 'SCOTT',  'ANALYST',   7566, TO_DATE('1982-12-09', 'YYYY-MM-DD'), 3000, NULL, 20, TO_DATE('2000-01-01', 'YYYY-MM-DD'));
INSERT INTO S2DOTNETDEMO.EMP VALUES (7839, 'KING',	 'PRESIDENT', NULL, TO_DATE('1981-11-17', 'YYYY-MM-DD'), 5000, NULL, 10, TO_DATE('2000-01-01', 'YYYY-MM-DD'));
INSERT INTO S2DOTNETDEMO.EMP VALUES (7844, 'TURNER', 'SALESMAN',  7698, TO_DATE('1981-09-08', 'YYYY-MM-DD'), 1500,	  0, 30, TO_DATE('2000-01-01', 'YYYY-MM-DD'));
INSERT INTO S2DOTNETDEMO.EMP VALUES (7876, 'ADAMS',  'CLERK',	  7788, TO_DATE('1983-01-12', 'YYYY-MM-DD'), 1100, NULL, 20, TO_DATE('2000-01-01', 'YYYY-MM-DD'));
INSERT INTO S2DOTNETDEMO.EMP VALUES (7900, 'JAMES',  'CLERK',	  7698, TO_DATE('1981-12-03', 'YYYY-MM-DD'),  950, NULL, 30, TO_DATE('2000-01-01', 'YYYY-MM-DD'));
INSERT INTO S2DOTNETDEMO.EMP VALUES (7902, 'FORD',	 'ANALYST',   7566, TO_DATE('1981-12-03', 'YYYY-MM-DD'), 3000, NULL, 20, TO_DATE('2000-01-01', 'YYYY-MM-DD'));
INSERT INTO S2DOTNETDEMO.EMP VALUES (7934, 'MILLER', 'CLERK',	  7782, TO_DATE('1982-01-23', 'YYYY-MM-DD'), 1300, NULL, 10, TO_DATE('2000-01-01', 'YYYY-MM-DD'));
INSERT INTO S2DOTNETDEMO.DEPT VALUES (10, 'ACCOUNTING', 'NEW YORK', 0, 1);
INSERT INTO S2DOTNETDEMO.DEPT VALUES (20, 'RESEARCH',	'DALLAS',	0, 1);
INSERT INTO S2DOTNETDEMO.DEPT VALUES (30, 'SALES',		'CHICAGO',	0, 1);
INSERT INTO S2DOTNETDEMO.DEPT VALUES (40, 'OPERATIONS', 'BOSTON',	0, 1);
INSERT INTO S2DOTNETDEMO.EMP2 VALUES (7369, 'SMITH', 20);
INSERT INTO S2DOTNETDEMO.EMP2 VALUES (7499, 'ALLEN', 30);
INSERT INTO S2DOTNETDEMO.EMP_NULLABLE VALUES (1, 'ADAMS', 'CLERK', 7788, TO_DATE('1983-01-12', 'YYYY-MM-DD'), 1100, NULL, 20, TO_DATE('2000-01-01', 'YYYY-MM-DD'), TO_DATE('2006-11-07', 'YYYY-MM-DD'));
INSERT INTO S2DOTNETDEMO.EMP_NULLABLE VALUES (10, 'JAMES', 'CLERK', 7698, TO_DATE('1981-12-03', 'YYYY-MM-DD'), 950, NULL, 30, TO_DATE('2000-01-01', 'YYYY-MM-DD'), NULL);
INSERT INTO S2DOTNETDEMO.EMP_NULLABLE VALUES (100, 'FORD', 'ANALYST', 7566, TO_DATE('1981-12-03', 'YYYY-MM-DD'), 3000, NULL, 20, TO_DATE('2000-01-01', 'YYYY-MM-DD'), TO_DATE('2006-11-07', 'YYYY-MM-DD'));
INSERT INTO S2DOTNETDEMO.GENERIC_NULLABLE VALUES (S2DOTNETDEMO.SEQ_GENERIC_NULLABLE.NEXTVAL, SYSDATE, 100);
INSERT INTO S2DOTNETDEMO.GENERIC_NULLABLE VALUES (S2DOTNETDEMO.SEQ_GENERIC_NULLABLE.NEXTVAL, NULL, 101);
INSERT INTO S2DOTNETDEMO.UNDER_SCORE VALUES (1,'table_name','table_name_','_table_name','_table_name_');
INSERT INTO S2DOTNETDEMO.DEPT2 VALUES (20, 'RESEARCH', 1);
INSERT INTO S2DOTNETDEMO.DEPT2 VALUES (30, 'SALES',    0);
INSERT INTO S2DOTNETDEMO.BASICTYPE VALUES (
	1,
	0,
	255,
	-128,
	32767,
	2147483647,
	9223372036854775807,
	9.876543,
	9.87654321098765,
	9999999999999999999999999999,
	'|\`',
	TO_DATE('1980-12-17 12:34:56', 'YYYY-MM-DD HH24:MI:SS')
);
INSERT INTO S2DOTNETDEMO.BASICTYPE (
	id
) VALUES (
	2
);
INSERT INTO S2DOTNETDEMO.BASICTYPE VALUES (
	3,
	1,
	2,
	3,
	4,
	5,
	6,
	7,
	8,
	9,
	'10',
	NULL
);

INSERT INTO S2DOTNETDEMO.DECIMAL_VERSION_NO VALUES(10, 'Decimal', 100);
INSERT INTO S2DOTNETDEMO.INT_VERSION_NO VALUES(10, 'Int', 100);

COMMIT;

CREATE OR REPLACE FUNCTION  "S2DOTNETDEMO"."SALES_TAX2" 
(sales in NUMBER)
return NUMBER
is
begin
return sales * 0.2;
end;
/
 

CREATE OR REPLACE PROCEDURE  "S2DOTNETDEMO"."SALES_TAX" 
(sales IN NUMBER,
tax OUT NUMBER)
is
begin
tax := sales * 0.2;
end;
/
 CREATE OR REPLACE PROCEDURE  "S2DOTNETDEMO"."SALES_TAX3" 
(sales IN OUT NUMBER)
is
begin
sales := sales * 0.2;
end;
/
 CREATE OR REPLACE PROCEDURE  "S2DOTNETDEMO"."SALES_TAX4" 
(sales IN NUMBER,
tax OUT NUMBER,
total OUT NUMBER)
is
begin
tax := sales * 0.2;
total := sales * 1.2;
end;
/

