CREATE DATABASE `s2dotnetdemo` /*!40100 DEFAULT CHARACTER SET utf8 */;
use s2dotnetdemo;

DROP TABLE IF EXISTS `s2dotnetdemo`.`DEPT`;
CREATE TABLE `s2dotnetdemo`.`DEPT` (
	`DEPTNO` TINYINT NOT NULL,
	`DNAME` VARCHAR(14) NULL,
	`LOC` VARCHAR(13) NULL,
	`VERSIONNO` INT NULL,
	`ACTIVE` TINYINT NULL,
	PRIMARY KEY(`DEPTNO`)
)
ENGINE = InnoDB;

DROP TABLE IF EXISTS `s2dotnetdemo`.`DEPT2`;
CREATE TABLE `s2dotnetdemo`.`DEPT2` (
	`DEPTNO` TINYINT NOT NULL,
	`DNAME` VARCHAR(14) NULL,
	`ACTIVE` TINYINT NULL,
	PRIMARY KEY(`DEPTNO`)
)
ENGINE = InnoDB;

DROP TABLE IF EXISTS `s2dotnetdemo`.`EMP`;
CREATE TABLE `s2dotnetdemo`.`EMP` (
	`EMPNO` INTEGER NOT NULL,
	`ENAME` VARCHAR(10) NULL,
	`JOB` VARCHAR(9),
	`MGR` INTEGER NULL,
	`HIREDATE` TIMESTAMP NULL,
	`SAL` INTEGER NULL,
	`COMM` DECIMAL(7, 2) NULL,
	`DEPTNO` TINYINT NULL,
	`TSTAMP` TIMESTAMP NULL,
	PRIMARY KEY(`EMPNO`)
)
ENGINE = InnoDB;

DROP TABLE IF EXISTS `s2dotnetdemo`.`EMP2`;
CREATE TABLE `s2dotnetdemo`.`EMP2` (
	`EMPNO` INTEGER NOT NULL,
	`ENAME` VARCHAR(10) NULL,
	`DEPTNUM` TINYINT NULL,
	PRIMARY KEY(`EMPNO`)
)
ENGINE = InnoDB;

DROP TABLE IF EXISTS `s2dotnetdemo`.`EMP_NULLABLE`;
CREATE TABLE `s2dotnetdemo`.`EMP_NULLABLE` (
	`EMPNO` INTEGER NOT NULL,
	`ENAME` VARCHAR(10) NULL,
	`JOB` VARCHAR(9),
	`MGR` INTEGER NULL,
	`HIREDATE` TIMESTAMP NULL,
	`SAL` INTEGER NULL,
	`COMM` DECIMAL(7, 2) NULL,
	`DEPTNO` TINYINT NULL,
	`TSTAMP` TIMESTAMP NULL,
	`NULLABLENEXTRESTDATE` TIMESTAMP NULL,
	PRIMARY KEY(`EMPNO`)
)
ENGINE = InnoDB;

DROP TABLE IF EXISTS `s2dotnetdemo`.`GENERIC_NULLABLE`;
CREATE TABLE `s2dotnetdemo`.`GENERIC_NULLABLE` (
	`ID` INTEGER NOT NULL AUTO_INCREMENT,
	`DDATE` TIMESTAMP NULL,
	`ENTITYNO` INTEGER NULL,
	PRIMARY KEY(`ID`)
)
ENGINE = InnoDB;

DROP TABLE IF EXISTS `s2dotnetdemo`.`UNDER_SCORE`;
CREATE TABLE `s2dotnetdemo`.`UNDER_SCORE` (
	`UNDER_SCORE_NO` DECIMAL(4, 0) NOT NULL,
	`TABLE_NAME` VARCHAR(50),
	`TABLE_NAME_` VARCHAR(50),
	`_TABLE_NAME` VARCHAR(50),
	`_TABLE_NAME_` VARCHAR(50),
	PRIMARY KEY(`UNDER_SCORE_NO`)
)
ENGINE = InnoDB;

DROP TABLE IF EXISTS `s2dotnetdemo`.`IDTABLE`;
CREATE TABLE `s2dotnetdemo`.`IDTABLE` (
	`ID` INTEGER NOT NULL AUTO_INCREMENT,
	`ID_NAME` VARCHAR(9),
	PRIMARY KEY(`ID`)
)
ENGINE = InnoDB;

DROP TABLE IF EXISTS `s2dotnetdemo`.`BASICTYPE`;
CREATE TABLE `s2dotnetdemo`.`BASICTYPE` (
	`ID` DECIMAL(18, 0) NOT NULL,
	`BOOLTYPE` BIT NULL,
	`BYTETYPE` TINYINT UNSIGNED NULL,
	`SBYTETYPE` TINYINT NULL,
	`INT16TYPE` SMALLINT NULL,
	`INT32TYPE` INTEGER NULL,
	`INT64TYPE` BIGINT NULL,
	`SINGLETYPE` FLOAT(24, 8) NULL,
	`DOUBLETYPE` DOUBLE PRECISION NULL,
	`DECIMALTYPE` DECIMAL(28, 0) NULL,
	`STRINGTYPE` TEXT NULL,
	`DATETIMETYPE` TIMESTAMP NULL,
	PRIMARY KEY(`ID`)
)
ENGINE = InnoDB;

INSERT INTO `s2dotnetdemo`.`EMP` VALUES (7369, 'SMITH',  'CLERK',       7902, '1980-12-17 00:00:00',  800, NULL, 20, '2000-01-01 00:00:00');
INSERT INTO `s2dotnetdemo`.`EMP` VALUES (7499, 'ALLEN',  'SALESMAN',    7698, '1981-02-20 00:00:00', 1600,  300, 30, '2000-01-01 00:00:00');
INSERT INTO `s2dotnetdemo`.`EMP` VALUES (7521, 'WARD',   'SALESMAN',    7698, '1981-02-22 00:00:00', 1250,  500, 30, '2000-01-01 00:00:00');
INSERT INTO `s2dotnetdemo`.`EMP` VALUES (7566, 'JONES',  'MANAGER',     7839, '1981-04-02 00:00:00', 2975, NULL, 20, '2000-01-01 00:00:00');
INSERT INTO `s2dotnetdemo`.`EMP` VALUES (7654, 'MARTIN', 'SALESMAN',    7698, '1981-09-28 00:00:00', 1250, 1400, 30, '2000-01-01 00:00:00');
INSERT INTO `s2dotnetdemo`.`EMP` VALUES (7698, 'BLAKE',  'MANAGER',     7839, '1981-05-01 00:00:00', 2850, NULL, 30, '2000-01-01 00:00:00');
INSERT INTO `s2dotnetdemo`.`EMP` VALUES (7782, 'CLARK',  'MANAGER',     7839, '1981-06-09 00:00:00', 2450, NULL, 10, '2000-01-01 00:00:00');
INSERT INTO `s2dotnetdemo`.`EMP` VALUES (7788, 'SCOTT',  'ANALYST',     7566, '1982-12-09 00:00:00', 3000, NULL, 20, '2000-01-01 00:00:00');
INSERT INTO `s2dotnetdemo`.`EMP` VALUES (7839, 'KING',   'PRESIDENT',   NULL, '1981-11-17 00:00:00', 5000, NULL, 10, '2000-01-01 00:00:00');
INSERT INTO `s2dotnetdemo`.`EMP` VALUES (7844, 'TURNER', 'SALESMAN',    7698, '1981-09-08 00:00:00', 1500,    0, 30, '2000-01-01 00:00:00');
INSERT INTO `s2dotnetdemo`.`EMP` VALUES (7876, 'ADAMS',  'CLERK',       7788, '1983-01-12 00:00:00', 1100, NULL, 20, '2000-01-01 00:00:00');
INSERT INTO `s2dotnetdemo`.`EMP` VALUES (7900, 'JAMES',  'CLERK',       7698, '1981-12-03 00:00:00',  950, NULL, 30, '2000-01-01 00:00:00');
INSERT INTO `s2dotnetdemo`.`EMP` VALUES (7902, 'FORD',   'ANALYST',     7566, '1981-12-03 00:00:00', 3000, NULL, 20, '2000-01-01 00:00:00');
INSERT INTO `s2dotnetdemo`.`EMP` VALUES (7934, 'MILLER', 'CLERK',       7782, '1982-01-23 00:00:00', 1300, NULL, 10, '2000-01-01 00:00:00');
INSERT INTO `s2dotnetdemo`.`DEPT` VALUES (10, 'ACCOUNTING', 'NEW YORK', 0, 1);
INSERT INTO `s2dotnetdemo`.`DEPT` VALUES (20, 'RESEARCH',   'DALLAS',   0, 1);
INSERT INTO `s2dotnetdemo`.`DEPT` VALUES (30, 'SALES',      'CHICAGO',  0, 1);
INSERT INTO `s2dotnetdemo`.`DEPT` VALUES (40, 'OPERATIONS', 'BOSTON',   0, 1);
INSERT INTO `s2dotnetdemo`.`EMP2` VALUES (7369, 'SMITH', 20);
INSERT INTO `s2dotnetdemo`.`EMP2` VALUES (7499, 'ALLEN', 30);
INSERT INTO `s2dotnetdemo`.`EMP_NULLABLE` VALUES (1, 'ADAMS', 'CLERK', 7788, '1983-01-12 00:00:00', 1100, NULL, 20, '2000-01-01 00:00:00', '2006-11-07 00:00:00');
INSERT INTO `s2dotnetdemo`.`EMP_NULLABLE` VALUES (10, 'JAMES', 'CLERK', 7698, '1981-12-03 00:00:00', 950, NULL, 30, '2000-01-01 00:00:00', null);
INSERT INTO `s2dotnetdemo`.`EMP_NULLABLE` VALUES (100, 'FORD', 'ANALYST', 7566, '1981-12-03 00:00:00', 3000, NULL, 20, '2000-01-01 00:00:00', '2006-11-07 00:00:00');
INSERT INTO `s2dotnetdemo`.`GENERIC_NULLABLE` (DDATE, ENTITYNO) VALUES ('2000-12-31 12:34:56', 100);
INSERT INTO `s2dotnetdemo`.`GENERIC_NULLABLE` (DDATE, ENTITYNO) VALUES (null, 101);
INSERT INTO `s2dotnetdemo`.`UNDER_SCORE` VALUES (1,'table_name','table_name_','_table_name','_table_name_');
INSERT INTO `s2dotnetdemo`.`DEPT2` VALUES (20, 'RESEARCH', 1);
INSERT INTO `s2dotnetdemo`.`DEPT2` VALUES (30, 'SALES',    0);
INSERT INTO `s2dotnetdemo`.`BASICTYPE` VALUES (
    1,
    0,
    255,
    -128,
    32767,
    2147483647,
    9223372036854775807,
    9.876543,
    9.87654321098765,
    9999999999999999999999999999,
    '|\\`',
    '1980-12-17 12:34:56'
);
INSERT INTO `s2dotnetdemo`.`BASICTYPE` (
    id
) VALUES (
    2
);
INSERT INTO `s2dotnetdemo`.`BASICTYPE` VALUES (
    3,
    1,
    2,
    3,
    4,
    5,
    6,
    7,
    8,
    9,
    '10',
    NULL
);
