﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Remoting.Proxies;
using System.Runtime.Remoting.Messaging;
using System.Reflection;

namespace aopsample
{
    class MyProxyClass:RealProxy
    {
        private Object myObjectInstance = null;
        private Type myType = null;

        public MyProxyClass(Type argType) : base(argType)
        {
            myType = argType;
            myObjectInstance = Activator.CreateInstance(argType);
        }

        public override IMessage Invoke(IMessage message)
        {
            IMethodMessage myMethodMessage = (IMethodMessage)message;

            Object returnValue = myType.InvokeMember(myMethodMessage.MethodName,
                                     BindingFlags.InvokeMethod, null, myObjectInstance,
                                     myMethodMessage.Args);
            ReturnMessage myReturnMessage = new ReturnMessage(returnValue, null, 0,
                                     ((IMethodCallMessage)message).LogicalCallContext,
                                     (IMethodCallMessage)message);
            return myReturnMessage;
        }
    }
}

