﻿using System;
using System.Reflection;
using System.Runtime.Remoting.Messaging;
using System.Runtime.Remoting.Proxies;

namespace Modify
{
    class ToUpperProxy:RealProxy 
    {
        ToUpper realObject = new ToUpper();

        public ToUpperProxy()
          : base(typeof(IModify)) // 透過プロキシのインタフェースを指定
        {
        }

        public override IMessage Invoke(IMessage msg)
        {
            IMethodMessage method = msg as IMethodMessage;
            object[] args = method.Args;

            MethodInfo methodInfo = (MethodInfo)method.MethodBase;
            object result = methodInfo.Invoke(realObject, args);

            return new ReturnMessage(
              result,
              args,
              args.Length,
              method.LogicalCallContext,
              (IMethodCallMessage)msg);
        }
    }
}
