﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Bellmonzo.Koubai.Common;
using Bellmonzo.Koubai.Logics.Service.Impl;
using Bellmonzo.Koubai.Logics.Dto;
using Bellmonzo.Koubai.Logics.Page;
using Seasar.Windows.Attr;

namespace Bellmonzo.Koubai.Forms
{
    [ControlModifier("lbl", "")]
    [Control("gridList", "DataSource", "List")]
    public partial class FrmRoomList : FrmBase
    {
        protected RoomListServiceImpl service;
        

        public int? BuildID { get; set; }

        public FrmRoomList()
        {
            try
            {
                InitializeComponent();
            }
            catch (Exception ex)
            {
                FormLogger.Error(ex);
                MessageBox.Show(ex.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }
        }

        private void FrmRoomList_Load(object sender, EventArgs e)
        {
            try
            {
                FormLogger.Load(this);
                DataSource = service.Find(BuildID);
            }
            catch (Exception ex)
            {
                FormLogger.Error(ex);
                MessageBox.Show(ex.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }
        }

        private void gridList_CellDoubleClick(object sender, DataGridViewCellEventArgs e)
        {
            try
            {
                int? id = ((RoomListPage)DataSource).List[gridList.CurrentRow.Index].ID;
                dispatcher.ShowRoom(id.Value);
                DataSource = service.Find(BuildID);
            }
            catch (Exception ex)
            {
                FormLogger.Error(ex);
                MessageBox.Show(ex.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }
        }
    }
}
