﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Seasar.Windows.Attr;
using Bellmonzo.Koubai.Common;
using Bellmonzo.Koubai.Logics.Service.Impl;

namespace Bellmonzo.Koubai.Forms
{
    [ControlModifier("txt", "")]
    [Control("lblBuildName","Text", "BuildName")]
    [Control("lblRoomID","Text", "RoomID")]
    [Control("lblRoomName", "Text", "RoomName")]
    [Control("lblTrackID","Text", "TrackID")]
    [Control("lblJournalID", "Text", "JournalID")]
    [Control("lblExplanation", "Text", "Explanation")]
    [Control("cmbCompany", "SelectedValue", "Company")]
    [Control("dtpOccurenceDay", "Value", "OccurenceDay")]
    [Control("dtpGuaranteeDay", "Value", "GuaranteeDay")]
    [Control("cmbCategory", "Text", "Category")]
    public partial class FrmTrack : FrmBase
    {
        protected TrackServiceImpl service;

        public int TrackID { get; set; }
        public int RoomID { get; set; }

        public FrmTrack()
        {
            try
            {
                InitializeComponent();
            }
            catch (Exception ex)
            {
                FormLogger.Error(ex);
                MessageBox.Show(ex.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }
        }

        private void FrmTrack_Load(object sender, EventArgs e)
        {
            try
            {
                FormLogger.Load(this);
                DataSource = service.Find(RoomID, TrackID);
            }
            catch (Exception ex)
            {
                FormLogger.Error(ex);
                MessageBox.Show(ex.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }
        }
    }
}
