﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Bellmonzo.Koubai.Logics.Service.Impl;
using Bellmonzo.Koubai.Logics.Dto;
using Bellmonzo.Koubai.Logics.Page;
using Bellmonzo.Koubai.Common;
using Seasar.Windows.Attr;

namespace Bellmonzo.Koubai.Forms
{

    [ControlModifier("lbl", "")]
    [Control("gridList", "DataSource", "List")]
    public partial class FrmRoom : FrmBase
    {
        protected RoomServiceImpl service;

        public int RoomID { get; set; }

        public FrmRoom()
        {
            try
            {
                InitializeComponent();
            }
            catch (Exception ex)
            {
                FormLogger.Error(ex);
                MessageBox.Show(ex.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }
        }

        private void FrmRoom_Load(object sender, EventArgs e)
        {
            try
            {
                FormLogger.Load(this);
                DataSource = service.Find(RoomID);
            }
            catch (Exception ex)
            {
                FormLogger.Error(ex);
                MessageBox.Show(ex.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }
        }

        private void gridList_CellDoubleClick(object sender, DataGridViewCellEventArgs e)
        {
            try
            {
                int roomID = ((RoomPage)DataSource).List[gridList.CurrentRow.Index].RoomID;
                int trackID = ((RoomPage)DataSource).List[gridList.CurrentRow.Index].TrackID;
                dispatcher.ShowTrack(roomID,trackID);
                DataSource = service.Find(RoomID);
            }
            catch (Exception ex)
            {
                FormLogger.Error(ex);
                MessageBox.Show(ex.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }
        }

        private void btnOpenExcel_Click(object sender, EventArgs e)
        {
            var xlspath =Common.PathUtls.GetRootPath() + @"\..\..\..\..\xls\" + RoomID.ToString() + ".xlsx";

            System.Diagnostics.Process.Start("excel.exe", xlspath);
        }
    }
}
