﻿using System;
using System.Reflection;
using System.Windows.Forms;
using log4net;
using Bellmonzo.Koubai.Logics.Page;
using Bellmonzo.Koubai.Logics.Service;
using Seasar.Windows;
using Seasar.Windows.Attr;

namespace Bellmonzo.Koubai.Forms
{
    [ControlModifier("txt", "")]
    [Control("gridList", "DataSource", "List")]
    public partial class FrmDepartmentList : S2Form
    {
/// <summary>
/// 例外エラーメッセージ書式
/// </summary>
        private const string EXCEPTION_MSG_FORMAT = "予期できないエラーが発生しました。詳細を確認してください。（{0}）";

        /// <summary>
        /// ログ(log4net)
        /// </summary>
        private static readonly ILog logger =
            LogManager.GetLogger(MethodBase.GetCurrentMethod().DeclaringType);

        /// <summary>
        /// 画面ディスパッチャー
        /// </summary>
        protected IFormDispatcher dispatcher;

        /// <summary>
        /// 部門一覧サービス
        /// </summary>
        protected IDepartmentListService service;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public FrmDepartmentList()
        {
            InitializeComponent();

            _InitializeGridView();
        }

        /// <summary>
        /// 新規ボタンを押したときの処理
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnNew_Click(object sender, EventArgs e)
        {
            try
            {
                dispatcher.ShowMasterEdit(null);
                DataSource = service.GetAll();
            }
            catch (Exception ex)
            {
                logger.ErrorFormat(EXCEPTION_MSG_FORMAT, ex.Message);
                logger.Error(ex.StackTrace);
                MessageBox.Show(ex.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }
        }

        /// <summary>
        /// 閉じるボタンを押したときの処理
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnClose_Click(object sender, EventArgs e)
        {
            logger.InfoFormat("{0}を終了", Name);
            Close();
        }

        /// <summary>
        /// フォームをロードしたときの処理
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void FrmDepartmentList_Load(object sender, EventArgs e)
        {
            try
            {
                logger.InfoFormat("{0}がロードされました", Name);

                DataSource = service.GetAll();
            }
            catch (Exception ex)
            {
                logger.ErrorFormat(EXCEPTION_MSG_FORMAT, ex.Message);
                logger.Error(ex.StackTrace);
                MessageBox.Show(ex.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }
        }

        /// <summary>
        /// グリッドをダブルクリックしたときの処理
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void gridList_CellDoubleClick(object sender, DataGridViewCellEventArgs e)
        {
            try
            {
                int? id = ((DepartmentListPage)DataSource).List[gridList.CurrentRow.Index].Id;
                dispatcher.ShowMasterEdit(id);

                DataSource = service.GetAll();
            }
            catch (Exception ex)
            {
                logger.ErrorFormat(EXCEPTION_MSG_FORMAT, ex.Message);
                logger.Error(ex.StackTrace);
                MessageBox.Show(ex.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }
        }

        /// <summary>
        /// GridViewを初期化する
        /// </summary>
        private void _InitializeGridView()
        {
            gridList.RowCount = 0;
        }
    }
}
