﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Seasar.Windows.Attr;
using Bellmonzo.Koubai.Logics.Service.Impl;
using Bellmonzo.Koubai.Common;
using Bellmonzo.Koubai.Logics.Page;


namespace Bellmonzo.Koubai.Forms
{
    [ControlModifier("txt", "")]
    [Control("gridList", "DataSource", "List")]
    public partial class FrmBuildList :  FrmBase
    {
        /// <summary>
        /// 建物一覧サービス
        /// </summary>
        protected BuildListServiceImpl service;


        public FrmBuildList()
        {
            InitializeComponent();
        }

        private void FrmBuildList_Load(object sender, EventArgs e)
        {
            try
            {
                FormLogger.Load(this);
                DataSource = service.GetAll();
            }
            catch (Exception ex)
            {
                FormLogger.Error(ex);
                MessageBox.Show(ex.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }

        }

        private void gridList_CellDoubleClick(object sender, DataGridViewCellEventArgs e)
        {
            try
            {
                int? id = ((BuildListPage)DataSource).List[gridList.CurrentRow.Index].ID;
                dispatcher.ShowRoomList(id);
                DataSource = service.GetAll();
            }
            catch (Exception ex)
            {
                FormLogger.Error(ex);
                MessageBox.Show(ex.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
            }
        }
  
    }
}
