﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using log4net;
using System.Reflection;
using System.Windows.Forms;

namespace Bellmonzo.Koubai.Common
{
    public class FormLogger
    {
        /// <summary>
        /// 例外エラーメッセージ書式
        /// </summary>
        private const string EXCEPTION_MSG_FORMAT = "予期できないエラーが発生しました。詳細を確認してください。（{0}）";

        /// <summary>
        /// ログ(log4net)
        /// </summary>
        private static readonly ILog logger =
            LogManager.GetLogger(MethodBase.GetCurrentMethod().DeclaringType);

        public static void Load(Form form)
        {
            logger.InfoFormat("{0}がロードされました", form.Name);
        }

        public static void Error(Exception ex)
        {
            logger.ErrorFormat(EXCEPTION_MSG_FORMAT, ex.Message);
            logger.Error(ex.StackTrace);
        }
    }
}
