﻿using Bellmonzo.Koubai.Logics.Page;
using Bellmonzo.Koubai.Logics.Dao;
using Seasar.Quill.Attrs;

namespace Bellmonzo.Koubai.Logics.Service.Impl
{
    [Implementation]
    public class TrackServiceImpl
    {

        protected IJournalDao journalDao;
        protected IBuildDao builddao;
        protected IRoomDao roomdao;
        protected ITrackDao trackdao;

        public TrackPage Find(int roomID,int trackID)
        {
            var page = new TrackPage();

            var roomdto = roomdao.GetData(roomID);
            page.RoomName = roomdto.Name;

            var trackdto = trackdao.GetData(roomID,trackID);
            page.RoomID = trackdto.RoomID;
            page.TrackID = trackdto.TrackID;
            page.JournalID = trackdto.JournalID;
            page.OccurenceDay = trackdto.OccurenceDay;
            page.TrackPrice = trackdto.TrackPrice;
            page.CompanyID = trackdto.CompanyID;
            page.ItemName = trackdto.ItemName;
            page.GuaranteeDay = trackdto.GuaranteeDay;
            page.PurchaserName = trackdto.PurchaserName;
            page.Category = trackdto.Category;

            if (roomdto.BuildID == null)
            {
                page.BuildName = string.Empty;
            }
            else
            {
                var builddto = builddao.GetData(roomdto.BuildID.Value);
                page.BuildName = builddto.Name;
            }

            if (trackdto.JournalID != null)
            {
                var journaldto = journalDao.GetData(trackdto.JournalID.Value);
                page.Explanation = journaldto.Explanation;
            }
            return page;
        }

    }
}
