﻿using Bellmonzo.Koubai.Logics.Page;
using Bellmonzo.Koubai.Logics.Dao;
using Seasar.Quill.Attrs;

namespace Bellmonzo.Koubai.Logics.Service.Impl
{
    [Implementation]
    public class RoomServiceImpl
    {
        protected IBuildDao builddao;
        protected IRoomDao roomdao;
        protected ITrackDao trackdao;

        public RoomPage Find(int roomID)
        {
            var page = new RoomPage();

            var roomdto = roomdao.GetData(roomID);
            page.RoomID = roomdto.ID.Value;
            page.RoomName = roomdto.Name;

            page.List = trackdao.FindByRoomID(roomID);
            if (roomdto.BuildID == null)
            {
                page.BuildName = string.Empty;
            }
            else
            {
                var builddto = builddao.GetData(roomdto.BuildID.Value);
                page.BuildName = builddto.Name;
            }       
            return page;
        }
    }
}
