﻿using Bellmonzo.Koubai.Logics.Page;
using Bellmonzo.Koubai.Logics.Dao;
using Seasar.Quill.Attrs;

namespace Bellmonzo.Koubai.Logics.Service.Impl
{
    [Implementation]
    public class RoomListServiceImpl 
    {
        protected IRoomDao dao;

        protected IBuildDao buildDao;

        public RoomListPage Find(int? buildID)
        {
            var page = new RoomListPage();
            if (buildID == null)
            {
                page.List = dao.GetAll();
            }
            else
            {
                page.List = dao.FindByBuildID(buildID.Value);
                var builddto = buildDao.GetData(buildID.Value);
                page.BuildName = builddto.Name;
            }
            return page;
        }
    }
}
