﻿using System.Collections.Generic;
using Bellmonzo.Koubai.Logics.Dto;
using Seasar.Dao.Attrs;
using Seasar.Quill.Attrs;

namespace Bellmonzo.Koubai.Logics.Dao
{
    [S2Dao]
    [Implementation]
    [Bean(typeof(TrackDto))]
    public interface ITrackDao
    {
        [Sql("select * from t_track where room_id = /*roomID*/1 order by t_track.occurence_day")]
        IList<TrackDto> FindByRoomID(int roomID);
        
        [Sql("select * from t_track where t_track.room_id = /*roomID*/1 and t_track.track_id = /*trackID*/1")]
        TrackDto GetData(int roomID, int trackID);
    }
}
