﻿using System.Collections.Generic;
using Bellmonzo.Koubai.Logics.Dto;
using Seasar.Dao.Attrs;
using Seasar.Quill.Attrs;

namespace Bellmonzo.Koubai.Logics.Dao
{
    [S2Dao]
    [Implementation]
    [Bean(typeof(RoomDto))]
    public interface IRoomDao
    {
        IList<RoomDto> GetAll();

        [Query("t_room.id = /*id*/1")]
        RoomDto GetData(int id);

        [Query("build_id = /*buildID*/1")]
        IList<RoomDto> FindByBuildID(int buildID);
    }
}
