﻿using System.Collections.Generic;
using Seasar.Dao.Attrs;
using Seasar.Quill.Attrs;
using Bellmonzo.Koubai.Logics.Dto;


namespace Bellmonzo.Koubai.Logics.Dao
    {
        /// <summary>
        /// 建物用DAO
        /// </summary>
        [S2Dao]
        [Implementation]
        [Bean(typeof(BuildDto))]
        public interface IBuildDao
        {
            /// <summary>
            /// 建物一覧を取得する
            /// </summary>
            /// <returns>建物リスト</returns>
            IList<BuildDto> GetAll();

            [Query("t_build.id = /*ID*/1")]
            BuildDto GetData(int ID);
        }
}
