#!/usr/bin/python3
# -*- coding: UTF-8 -*-
#
# 耐性的に下位互換の装備を装備一覧から削除する
# 同じ部位の装備同士を比較して完全な下位互換の装備を削除する
# 比較の差異に耐性以外の能力値を＋するような要素があった場合は削除しない
# ----------------------------------------------------------------------
# 入力
#     argv[1]: 装備ファイル名
#     argv[2]: ターゲット耐性
#     argv[3]: 目標加速　外でやる？
#     argv[4]: 目標隠密　外でやる？
#     argv[5]: 武器の持ち方　中でやる
#     argv[5]: 除外装備　外でやる？
#     argv[6]: 除外耐性　外でやる？
#     argv[7]: 除外部位　外でやる？
#     argv[8]: 見たい組み合わせ数
#
# 出力
#     要求を満たした組み合わせxn
#

from sys import argv
import re

# 部位別装備一覧ファイルを開く
print(argv[0], argv[1], argv[2], argv[3], argv[4], argv[5], argv[6], argv[7], argv[8])
#f = open(argv[1], 'r')

# リストにする
# equips  : 装備リスト
#   power : 数値   ターゲット耐性数
#   prt   : 文字   部位
#   equip : 文字列 装備名、銘
#   resi  : 文字列 耐性リスト
equips = []     # 装備の配列
#equipResis = [] # 装備の銘部分だけ脱いたやつ

for line in open(argv[1], 'r'):
    linearr = line[:len(line)-1].split(' ')
    equips.append({'power': linearr[0], 'prt': linearr[1],
            'equip': ' '.join(linearr[2:])})

#print(argv[2].split(' '))
#print(set().union(argv[2].split(' ')))
targetResi = set().union(argv[2].split(' '))
#print('targetResi:', targetResi)
# 装備にターゲットになっている耐性を設定する(後の比較用)
for eq in equips:
    resiT = set()

    # こんな感じのグループの配列をresultに入れる
    # r酸火
    # ;麻乱浮
    # (腕
    result=re.findall(
            '[{*r;~(+[][^*r;~(+/|[,}]*',
            re.search('{.*}', eq['equip']).group(0))

#   for r in argv[2]:
#       for res in result:
#           if res.count(r):
#               sym = res[0].replace('{', ';')
#               resiT.add(sym + r)
    #print('result:',result)
    for res in result:
        sym = res[0].replace('{', ';')
        #print('resilist:', [sym + r for r in res[1:] if r != ''])
        resiT |= {sym + r for r in res[1:]}

    #print('resiT:',resiT)
    eq['resitar'] = resiT & targetResi

    # 装備毎の全ての耐性リストを装備ディクショナリに追加する
    resiA = set()
    for res in result:
        sym = res[0].replace('{', ';')
        #for resichar in res[1:]: resiA.add(sym + resichar)
        resiA |= {sym + r for r in res[1:]}
    eq['resiall'] = resiA

#print(equips)
#print('--------------------------------------------------------------')

#
# 下位互換削除処理
# メモ：range(初期値, 終値, 増分)
#

# 下位互換弾いた装備リスト
equips_2 = []

for prt in {e['prt'] for e in equips}:
    # 装備群を部位ごとに分ける
    eq_1prt = [e for e in equips if e['prt'] == prt]

    # 耐性が少ない方からチェックする
    # 耐性が少ない装備(i)と耐性が多い装備(j)を比較する
    # jの装備と耐性が被ってなかったらjの装備を段々と耐性が少ないものへ
    # 移していく
    for i in range(len(eq_1prt)):
        print('チェック：', eq_1prt[i]['equip'])
        for j in range(len(eq_1prt)-1, i-1, -1):
            print('i:',i,', j:',j)

            # 全ての装備との比較が終わった
            # 下位互換ではないので残す
            if i == j:
                print('追加1：',eq_1prt[i]['equip'])
                equips_2.append(eq_1prt[i])
                break

            # iの装備がjの真部分集合ならiの装備を捨てる
            # 下位互換なので捨てる
            if eq_1prt[i]['resitar'] < eq_1prt[j]['resitar']:
                print('捨てる：',eq_1prt[i]['equip'])
                break
            # ターゲット耐性の数が同じだが、全体の耐性数が少ないので捨てる
            elif (eq_1prt[i]['resitar'] == eq_1prt[j]['resitar']
                    and eq_1prt[i]['resiall'] <= eq_1prt[j]['resiall']):
                print('捨てる：',eq_1prt[i]['equip'])
                break

        else:
            print('追加2：',eq_1prt[i]['equip'])
            equips_2.append(eq_1prt[i])

#            for resi in equips_1prt[i]['resitar']:
#                print('resi:',resi)
#                if resi in equips_1prt[j]['resitar']:
#                    # この装備とは耐性が被ってるかも
#                    # 他の耐性もチェックする
#                    continue
#                else:
#                    # この装備とは耐性が被ってない
#                    break
#            else:
#                # equipの耐性が全部被ってる
#                # 耐性が同じ数なら、まぁ使えそうなので残しておく
#                if equips_1prt[i]['power'] == equips_1prt[j]['power'] and :
#                    print('追加2：', equips_1prt[i]['equip'])
#                    equips_2.append(equips_1prt[i])
#                    break
#                else:
#                    print('下位互換なので捨てる')
#                    break

#print('--------------------------------------------------------------')
#print('equips2:\n', equips_2)

#
# 装備を部位毎にまとめる
#
equips_3 = []
for prt in 'abcdefghij':
    #print('prt:',prt)
    #print('ary:',[e for e in equips_2 if e['prt'] == prt])
    equips_3.append([e for e in equips_2 if e['prt'] == prt])
    
print('--------------------------------------------------------------')
print('equips_3:\n',equips_3)
print('--------------------------------------------------------------')
print('equips_3[1:]\n', equips_3[1:])

# 出力形式は３次元？配列みたいな感じ
# 装備セット１ List
# 　　装備１ Dict{部位(文字列)、耐性(集合型)、装備名(文字列)}
# 　　装備２ Dict{部位(文字列)、耐性(集合型)、装備名(文字列)}
# 装備セット２ List
# 　　装備１ Dict{部位(文字列)、耐性(集合型)、装備名(文字列)}
# 　　装備２ Dict{部位(文字列)、耐性(集合型)、装備名(文字列)}

ckque=[]
def assemble(alleq, work=[], ck=1):
    """装備の組み合わせをひたすら作る"""
    #print('--------------')
    if alleq == []:
        #print('* return *')
        return
    if alleq[0] == []:
        if ck >= 10:
            ckque.append(work)
        assemble(alleq[1:], work, ck + 1)
    #print('work:', work, 'ck:', ck)
    #print('alleq[0]:', alleq[0])
    # 装備１つごとのループ
    for prt in alleq[0]:
        #print('print prt:', prt)
        if ck >= 10:
            #print('--- ck3 ---')
            ckque.append(work + [prt])
        elif ck == 3:
            #print('--- ck2 ---')
            alleq[0].remove(prt) # ここだけ本番用に直して・・直さなくて良いかも
            assemble(alleq, work + [prt], ck + 1)
        else:
            #print('--- else ---')
            #print('alleq[1:]:\n', alleq[1:])
            #print('work:', work)
            #print('ck:',ck)
            assemble(alleq[1:], work + [prt], ck + 1)


assemble(equips_3)

print('print ckque:\n', ckque)

print('--------------------------------------------------------------')

# result
# {'a': 武器１},
# {'b': 武器２},
# {'c': 指輪},
# {'c': 指輪},
# ...
result = []
def check(assemList, num: int, resi):
    """\
    要求を満たす組み合わせを探す
    assemList  装備の組み合わせが入ってるリスト・キュー
    num        見たい組み合わせの数
    resi       ターゲット耐性 
    """
    # 現在見つかっている要求を満たす組み合わせ数
    ima = 0
    while ima != num:
        try:
            a = assemList.pop(0)
        except IndexError:
            # TODO:なんかする
            break

        # 組み合わせた装備セットの耐性を集合する
        a_resi = set().union(*[r['resitar'] for r in a])
        print(a_resi)

        # 組み合わせた装備の耐性が要求耐性を満たしていたら合格リストへ入れる
        if a_resi >= resi:
            print(a)
            print([{e['equip'], e['prt']} for e in a])
            assemEq = {'equips': [{e['equip'], e['prt']} for e in a],
                    'resi': set().union(*[r['resiall'] for r in a])}
            result.append(assemEq)
            ima+=1

check(ckque, int(argv[8]), targetResi)

print('--------------------------------------------------------------')
print('targetResi:', targetResi)
print('result:', result)

# 明日やる
# 'resitar'がいらない気がするので調べること

quit()

